/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseSecurityGroupListTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseSecurityGroupTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SecurityGroupApiExpectTest")
public class SecurityGroupApiExpectTest
extends BaseNovaApiExpectTest {
    public void testListSecurityGroupsWhenResponseIs2xx() throws Exception {
        HttpRequest list = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygroup_list.json"))).build();
        NovaApi apiWhenSecurityGroupsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, list, listResponse);
        Assert.assertEquals((Set)apiWhenSecurityGroupsExist.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-1.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-3.region-a.geo-1"));
        Assert.assertEquals((String)((SecurityGroupApi)apiWhenSecurityGroupsExist.getSecurityGroupExtensionForZone("az-1.region-a.geo-1").get()).list().toString(), (String)new ParseSecurityGroupListTest().expected().toString());
    }

    public void testListSecurityGroupsWhenReponseIs404IsEmpty() throws Exception {
        HttpRequest listListSecurityGroups = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse listListSecurityGroupsResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoSecurityGroupsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, listListSecurityGroups, listListSecurityGroupsResponse);
        Assert.assertTrue((boolean)((SecurityGroupApi)apiWhenNoSecurityGroupsExist.getSecurityGroupExtensionForZone("az-1.region-a.geo-1").get()).list().isEmpty());
    }

    public void testGetSecurityGroupWhenResponseIs2xx() throws Exception {
        HttpRequest getSecurityGroup = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups/0")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse getSecurityGroupResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygroup_details.json"))).build();
        NovaApi apiWhenSecurityGroupsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, getSecurityGroup, getSecurityGroupResponse);
        Assert.assertEquals((String)((SecurityGroupApi)apiWhenSecurityGroupsExist.getSecurityGroupExtensionForZone("az-1.region-a.geo-1").get()).get("0").toString(), (String)new ParseSecurityGroupTest().expected().toString());
    }

    public void testGetSecurityGroupWhenResponseIs404() throws Exception {
        HttpRequest getSecurityGroup = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups/0")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse getSecurityGroupResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoSecurityGroupsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, getSecurityGroup, getSecurityGroupResponse);
        Assert.assertNull((Object)((SecurityGroupApi)apiWhenNoSecurityGroupsExist.getSecurityGroupExtensionForZone("az-1.region-a.geo-1").get()).get("0"));
    }

    public void testCreateSecurityGroupWhenResponseIs2xx() throws Exception {
        HttpRequest create = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).payload(SecurityGroupApiExpectTest.payloadFromStringWithContentType((String)"{\"security_group\":{\"name\":\"jclouds-test\",\"description\":\"jclouds-test\"}}", (String)"application/json"))).build();
        HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygroup_created.json"))).build();
        NovaApi apiWhenSecurityGroupsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, create, createResponse);
        Assert.assertEquals((String)((SecurityGroupApi)apiWhenSecurityGroupsExist.getSecurityGroupExtensionForZone("az-1.region-a.geo-1").get()).createWithDescription("jclouds-test", "jclouds-test").toString(), (String)this.createExpected().toString());
    }

    public void testDeleteSecurityGroupWhenResponseIs2xx() throws Exception {
        HttpRequest delete = ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups/160")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse deleteResponse = HttpResponse.builder().statusCode(202).build();
        NovaApi apiWhenServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, delete, deleteResponse);
        Assert.assertTrue((boolean)((SecurityGroupApi)apiWhenServersExist.getSecurityGroupExtensionForZone("az-1.region-a.geo-1").get()).delete("160"));
    }

    public void testCreateSecurityGroupRuleForCidrBlockWhenResponseIs2xx() throws Exception {
        HttpRequest createRule = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-group-rules").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(SecurityGroupApiExpectTest.payloadFromStringWithContentType((String)"{\"security_group_rule\":{\"parent_group_id\":\"161\",\"cidr\":\"0.0.0.0/0\",\"ip_protocol\":\"tcp\",\"from_port\":\"80\",\"to_port\":\"8080\"}}", (String)"application/json"))).build();
        HttpResponse createRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygrouprule_created.json"))).build();
        NovaApi apiWhenSecurityGroupsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, createRule, createRuleResponse);
        Assert.assertEquals((String)((SecurityGroupApi)apiWhenSecurityGroupsExist.getSecurityGroupExtensionForZone("az-1.region-a.geo-1").get()).createRuleAllowingCidrBlock("161", Ingress.builder().ipProtocol(IpProtocol.TCP).fromPort(80).toPort(8080).build(), "0.0.0.0/0").toString(), (String)this.createRuleExpected().toString());
    }

    public void testCreateSecurityGroupRuleForSecurityGroupIdWhenResponseIs2xx() throws Exception {
        HttpRequest createRule = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-group-rules").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(SecurityGroupApiExpectTest.payloadFromStringWithContentType((String)"{\"security_group_rule\":{\"group_id\":\"999\",\"parent_group_id\":\"161\",\"ip_protocol\":\"tcp\",\"from_port\":\"80\",\"to_port\":\"8080\"}}", (String)"application/json"))).build();
        HttpResponse createRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygrouprule_created.json"))).build();
        NovaApi apiWhenSecurityGroupsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, createRule, createRuleResponse);
        Assert.assertEquals((String)((SecurityGroupApi)apiWhenSecurityGroupsExist.getSecurityGroupExtensionForZone("az-1.region-a.geo-1").get()).createRuleAllowingSecurityGroupId("161", Ingress.builder().ipProtocol(IpProtocol.TCP).fromPort(80).toPort(8080).build(), "999").toString(), (String)this.createRuleExpected().toString());
    }

    public void testDeleteSecurityGroupRuleWhenResponseIs2xx() throws Exception {
        HttpRequest deleteRule = ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-group-rules/161")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"*/*").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse deleteRuleResponse = HttpResponse.builder().statusCode(202).build();
        NovaApi apiWhenSecurityGroupsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, deleteRule, deleteRuleResponse);
        Assert.assertTrue((boolean)((SecurityGroupApi)apiWhenSecurityGroupsExist.getSecurityGroupExtensionForZone("az-1.region-a.geo-1").get()).deleteRule("161"));
    }

    private SecurityGroup createExpected() {
        return SecurityGroup.builder().description("jclouds-test").id("160").name("jclouds-test").rules((Set)ImmutableSet.of()).tenantId("dev_16767499955063").build();
    }

    private SecurityGroupRule createRuleExpected() {
        return ((SecurityGroupRule.Builder)((SecurityGroupRule.Builder)((SecurityGroupRule.Builder)SecurityGroupRule.builder().fromPort(80)).id("218").ipProtocol(IpProtocol.TCP)).ipRange("0.0.0.0/0").parentGroupId("161").toPort(8080)).build();
    }
}

