/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="SecurityGroupApiLiveTest", singleThreaded=true)
public class SecurityGroupApiLiveTest
extends BaseNovaApiLiveTest {
    public static final String SECURITY_GROUP_NAME = "testsg";

    public void list() throws Exception {
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            SecurityGroupApi securityGroupApi = (SecurityGroupApi)((NovaApi)this.api).getSecurityGroupExtensionForZone(zoneId).get();
            ImmutableSet securityGroupsList = securityGroupApi.list().toSet();
            Assert.assertNotNull((Object)securityGroupsList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGetAndDeleteSecurityGroup() throws Exception {
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            SecurityGroupApi securityGroupApi = (SecurityGroupApi)((NovaApi)this.api).getSecurityGroupExtensionForZone(zoneId).get();
            SecurityGroup securityGroup = null;
            try {
                securityGroup = securityGroupApi.createWithDescription(SECURITY_GROUP_NAME, "test security group");
                Assert.assertNotNull((Object)securityGroup);
                String id = securityGroup.getId();
                SecurityGroup theGroup = securityGroupApi.get(id);
                Assert.assertNotNull((Object)theGroup);
            }
            finally {
                if (securityGroup == null) continue;
                securityGroupApi.delete(securityGroup.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndDeleteSecurityGroupRule() throws Exception {
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            SecurityGroupApi securityGroupApi = (SecurityGroupApi)((NovaApi)this.api).getSecurityGroupExtensionForZone(zoneId).get();
            SecurityGroup securityGroup = null;
            try {
                securityGroup = securityGroupApi.createWithDescription(SECURITY_GROUP_NAME, "test security group");
                Assert.assertNotNull((Object)securityGroup);
                Iterator i$ = ImmutableSet.of((Object)22, (Object)8080).iterator();
                while (i$.hasNext()) {
                    int port = (Integer)i$.next();
                    SecurityGroupRule rule = securityGroupApi.createRuleAllowingCidrBlock(securityGroup.getId(), Ingress.builder().ipProtocol(IpProtocol.TCP).fromPort(port).toPort(port).build(), "0.0.0.0/0");
                    Assert.assertNotNull((Object)rule);
                    SecurityGroupRule rule2 = securityGroupApi.createRuleAllowingSecurityGroupId(securityGroup.getId(), Ingress.builder().ipProtocol(IpProtocol.TCP).fromPort(port).toPort(port).build(), securityGroup.getId());
                    Assert.assertNotNull((Object)rule2);
                }
                securityGroup = securityGroupApi.get(securityGroup.getId());
            }
            finally {
                if (securityGroup == null) continue;
                securityGroupApi.delete(securityGroup.getId());
            }
        }
    }
}

