/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.ServerWithSecurityGroups;
import org.jclouds.openstack.nova.v2_0.extensions.ServerWithSecurityGroupsApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ServerWithSecurityGroupsApiExpectTest")
public class ServerWithSecurityGroupsApiExpectTest
extends BaseNovaApiExpectTest {
    public void testGetServerWithSecurityGroups() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-create-server-ext/8d0a6ca5-8849-4b3d-b86e-f24c92490ebb");
        ServerWithSecurityGroupsApi api = (ServerWithSecurityGroupsApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/server_with_security_groups.json"))).build())).getServerWithSecurityGroupsExtensionForZone("az-1.region-a.geo-1").get();
        ServerWithSecurityGroups server = api.get("8d0a6ca5-8849-4b3d-b86e-f24c92490ebb");
        Assert.assertEquals((String)server.getId(), (String)"8d0a6ca5-8849-4b3d-b86e-f24c92490ebb");
        Assert.assertEquals((Set)server.getSecurityGroupNames(), (Set)ImmutableSet.of((Object)"default", (Object)"group1"));
    }

    public void testGetServerWithSecurityGroupsFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-create-server-ext/8d0a6ca5-8849-4b3d-b86e-f24c92490ebb");
        ServerWithSecurityGroupsApi api = (ServerWithSecurityGroupsApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getServerWithSecurityGroupsExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.get("8d0a6ca5-8849-4b3d-b86e-f24c92490ebb"));
    }
}

