/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerWithSecurityGroups;
import org.jclouds.openstack.nova.v2_0.extensions.ServerWithSecurityGroupsApi;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ServerWithSecurityGroupsApiLiveTest", singleThreaded=true)
public class ServerWithSecurityGroupsApiLiveTest
extends BaseNovaApiLiveTest {
    private ServerApi serverApi;
    private Optional<? extends ServerWithSecurityGroupsApi> apiOption;
    private String zone;

    @Override
    @BeforeGroups(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
        this.serverApi = ((NovaApi)this.api).getServerApiForZone(this.zone);
        this.apiOption = ((NovaApi)this.api).getServerWithSecurityGroupsExtensionForZone(this.zone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetServer() {
        if (this.apiOption.isPresent()) {
            for (Resource server : this.serverApi.list().concat()) {
                ServerWithSecurityGroups serverWithGroups = ((ServerWithSecurityGroupsApi)this.apiOption.get()).get(server.getId());
                Assert.assertEquals((String)serverWithGroups.getId(), (String)server.getId());
                Assert.assertEquals((String)serverWithGroups.getName(), (String)server.getName());
                Assert.assertNotNull((Object)serverWithGroups.getSecurityGroupNames());
            }
            Server testServer = null;
            try {
                testServer = this.createServerInZone(this.zone);
                ServerWithSecurityGroups results = ((ServerWithSecurityGroupsApi)this.apiOption.get()).get(testServer.getId());
                Assert.assertEquals((String)results.getId(), (String)testServer.getId());
                Assert.assertEquals((Set)results.getSecurityGroupNames(), (Set)ImmutableSet.of((Object)"default"));
            }
            finally {
                if (testServer != null) {
                    this.serverApi.delete(testServer.getId());
                }
            }
        }
    }
}

