/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.SimpleServerUsage;
import org.jclouds.openstack.nova.v2_0.domain.SimpleTenantUsage;
import org.jclouds.openstack.nova.v2_0.extensions.SimpleTenantUsageApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SimpleTenantUsageApiExpectTest")
public class SimpleTenantUsageApiExpectTest
extends BaseNovaApiExpectTest {
    private DateService dateService = new SimpleDateFormatDateService();

    public void testList() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-simple-tenant-usage");
        SimpleTenantUsageApi api = (SimpleTenantUsageApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/simple_tenant_usages.json"))).build())).getSimpleTenantUsageExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet results = api.list().toSet();
        SimpleTenantUsage usage = (SimpleTenantUsage)Iterables.getOnlyElement((Iterable)results);
        Assert.assertEquals((String)usage.getTenantId(), (String)"f8535069c3fb404cb61c873b1a0b4921");
        Assert.assertEquals((Object)usage.getTotalHours(), (Object)4.888888888888889E-7);
        Assert.assertEquals((Object)usage.getTotalLocalGbUsage(), (Object)1.9555555555555557E-5);
        Assert.assertEquals((Object)usage.getTotalMemoryMbUsage(), (Object)0.0015018666666666667);
        Assert.assertEquals((Object)usage.getTotalVcpusUsage(), (Object)7.333333333333333E-7);
        Assert.assertEquals((Object)usage.getStart(), (Object)this.dateService.iso8601DateParse("2012-04-18 12:18:39.702411"));
        Assert.assertEquals((Object)usage.getStop(), (Object)this.dateService.iso8601DateParse("2012-04-18 12:18:39.702499"));
        Assert.assertNotNull((Object)usage.getServerUsages());
        Assert.assertTrue((boolean)usage.getServerUsages().isEmpty());
    }

    public void testGet() throws Exception {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-simple-tenant-usage/test-1234");
        SimpleTenantUsageApi api = (SimpleTenantUsageApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/simple_tenant_usage.json"))).build())).getSimpleTenantUsageExtensionForZone("az-1.region-a.geo-1").get();
        SimpleTenantUsage usage = api.get("test-1234");
        Assert.assertEquals((String)usage.getTenantId(), (String)"f8535069c3fb404cb61c873b1a0b4921");
        SimpleTenantUsage expected = SimpleTenantUsage.builder().tenantId("f8535069c3fb404cb61c873b1a0b4921").totalHours(4.833333333333333E-7).totalLocalGbUsage(1.933333333333333E-5).start(this.dateService.iso8601DateParse("2012-04-18 13:32:07.255743")).stop(this.dateService.iso8601DateParse("2012-04-18 13:32:07.255743")).totalMemoryMbUsage(0.0014847999999999999).totalVcpusUsage(7.249999999999999E-7).serverUsages((Set)ImmutableSet.of((Object)SimpleServerUsage.builder().hours(2.4166666666666665E-7).uptime(91149L).flavorLocalGb(50.0).instanceName("test1").tenantId("f8535069c3fb404cb61c873b1a0b4921").flavorVcpus(2.0).flavorMemoryMb(4096.0).instanceStatus(SimpleServerUsage.Status.ACTIVE).flavorName("m1.medium").instanceCreated(this.dateService.iso8601SecondsDateParse("2012-04-17T12:12:58")).build(), (Object)SimpleServerUsage.builder().hours(2.4166666666666665E-7).uptime(84710L).flavorLocalGb(30.0).instanceName("mish_test").tenantId("f8535069c3fb404cb61c873b1a0b4921").flavorVcpus(1.0).flavorMemoryMb(2048.0).instanceStatus(SimpleServerUsage.Status.ACTIVE).flavorName("m1.small").instanceCreated(this.dateService.iso8601SecondsDateParse("2012-04-17T14:00:17")).build())).build();
        Assert.assertEquals((Object)usage, (Object)expected);
    }
}

