/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.SimpleTenantUsage;
import org.jclouds.openstack.nova.v2_0.extensions.SimpleTenantUsageApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="SimpleTenantUsageApiLiveTest")
public class SimpleTenantUsageApiLiveTest
extends BaseNovaApiLiveTest {
    public void testList() throws Exception {
        for (String zoneId : ((NovaApi)this.api).getConfiguredZones()) {
            Optional optApi = ((NovaApi)this.api).getSimpleTenantUsageExtensionForZone(zoneId);
            if (!optApi.isPresent() || !this.identity.endsWith(":admin")) continue;
            SimpleTenantUsageApi api = (SimpleTenantUsageApi)optApi.get();
            ImmutableSet usages = api.list().toSet();
            Assert.assertNotNull((Object)usages);
            for (SimpleTenantUsage usage : usages) {
                SimpleTenantUsage details = api.get(usage.getTenantId());
                Assert.assertNotNull((Object)details);
            }
        }
    }
}

