/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.VirtualInterface;
import org.jclouds.openstack.nova.v2_0.extensions.VirtualInterfaceApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="VirtualInterfaceApiLiveTest", singleThreaded=true)
public class VirtualInterfaceApiLiveTest
extends BaseNovaApiLiveTest {
    private Optional<? extends VirtualInterfaceApi> apiOption;
    private String zone;

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
        this.apiOption = ((NovaApi)this.api).getVirtualInterfaceExtensionForZone(this.zone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListVirtualInterfaces() {
        if (this.apiOption.isPresent()) {
            Server testServer = null;
            try {
                testServer = this.createServerInZone(this.zone);
                ImmutableSet results = ((VirtualInterfaceApi)this.apiOption.get()).listOnServer(testServer.getId()).toSet();
                for (VirtualInterface vif : results) {
                    Assert.assertNotNull((Object)vif.getId());
                    Assert.assertNotNull((Object)vif.getMacAddress());
                }
            }
            finally {
                if (testServer != null) {
                    ((NovaApi)this.api).getServerApiForZone(this.zone).delete(testServer.getId());
                }
            }
        }
    }
}

