/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Volume;
import org.jclouds.openstack.nova.v2_0.domain.VolumeAttachment;
import org.jclouds.openstack.nova.v2_0.domain.VolumeSnapshot;
import org.jclouds.openstack.nova.v2_0.extensions.VolumeApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.options.CreateVolumeOptions;
import org.jclouds.openstack.nova.v2_0.options.CreateVolumeSnapshotOptions;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VolumeApiExpectTest")
public class VolumeApiExpectTest
extends BaseNovaApiExpectTest {
    private DateService dateService = new SimpleDateFormatDateService();

    public void testListVolumes() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volumes");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_list.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet volumes = api.list().toSet();
        Assert.assertEquals((Set)volumes, (Set)ImmutableSet.of((Object)this.testVolume()));
    }

    public void testListVolumesFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volumes");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet volumes = api.list().toSet();
        Assert.assertTrue((boolean)volumes.isEmpty());
    }

    public void testListVolumesInDetail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volumes/detail");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_list_detail.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet volumes = api.listInDetail().toSet();
        Assert.assertEquals((Set)volumes, (Set)ImmutableSet.of((Object)this.testVolume()));
    }

    public void testListVolumesInDetailFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volumes/detail");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet volumes = api.listInDetail().toSet();
        Assert.assertTrue((boolean)volumes.isEmpty());
    }

    public void testCreateVolume() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volumes");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeApiExpectTest.payloadFromStringWithContentType((String)"{\"volume\":{\"display_name\":\"jclouds-test-volume\",\"display_description\":\"description of test volume\",\"size\":1}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_details.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        Volume volume = api.create(1, new CreateVolumeOptions[]{CreateVolumeOptions.Builder.name((String)"jclouds-test-volume").description("description of test volume")});
        Assert.assertEquals((Object)volume, (Object)this.testVolume());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testCreateVolumeFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volumes");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).endpoint(endpoint).method("POST").payload(VolumeApiExpectTest.payloadFromStringWithContentType((String)"{\"volume\":{\"display_name\":\"jclouds-test-volume\",\"display_description\":\"description of test volume\",\"size\":1}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResource("/volume_details.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        api.create(1, new CreateVolumeOptions[]{CreateVolumeOptions.Builder.name((String)"jclouds-test-volume").description("description of test volume")});
    }

    public void testGetVolume() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volumes/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_details.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        Volume volume = api.get("1");
        Assert.assertEquals((Object)volume, (Object)this.testVolume());
        Assert.assertEquals((Object)volume.getStatus(), (Object)Volume.Status.IN_USE);
        Assert.assertEquals((String)volume.getDescription(), (String)"This is a test volume");
        Assert.assertEquals((String)volume.getZone(), (String)"nova");
        Assert.assertEquals((String)volume.getName(), (String)"test");
        Assert.assertEquals((Object)volume.getStatus(), (Object)Volume.Status.IN_USE);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)volume.getAttachments()), (Object)this.testAttachment());
    }

    public void testGetVolumeFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volumes/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.get("1"));
    }

    public void testDeleteVolume() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volumes/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/attachment_details.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.delete("1"));
    }

    public void testDeleteVolumeFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volumes/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(404).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.delete("1"));
    }

    public void testListAttachments() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/attachment_list.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet attachments = api.listAttachmentsOnServer("instance-1").toSet();
        Assert.assertEquals((Set)attachments, (Set)ImmutableSet.of((Object)this.testAttachment()));
        VolumeAttachment attachment = (VolumeAttachment)Iterables.getOnlyElement((Iterable)attachments);
        Assert.assertEquals((String)attachment.getDevice(), (String)"/dev/vdc");
        Assert.assertEquals((String)attachment.getServerId(), (String)"b4785058-cb80-491b-baa3-e4ee6546450e");
        Assert.assertEquals((String)attachment.getId(), (String)"1");
        Assert.assertEquals((String)attachment.getVolumeId(), (String)"1");
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testListAttachmentsFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-2/os-volume_attachments");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(401).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        api.listAttachmentsOnServer("instance-2");
    }

    public void testGetAttachment() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/attachment_details.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        VolumeAttachment attachment = api.getAttachmentForVolumeOnServer("1", "instance-1");
        Assert.assertEquals((Object)attachment, (Object)this.testAttachment());
    }

    public void testGetAttachmentFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.getAttachmentForVolumeOnServer("1", "instance-1"));
    }

    public void testAttachVolume() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeApiExpectTest.payloadFromStringWithContentType((String)"{\"volumeAttachment\":{\"volumeId\":\"1\",\"device\":\"/dev/vdc\"}}", (String)"application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/attachment_details.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        VolumeAttachment result = api.attachVolumeToServerAsDevice("1", "instance-1", "/dev/vdc");
        Assert.assertEquals((Object)result, (Object)this.testAttachment());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testAttachVolumeFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeApiExpectTest.payloadFromStringWithContentType((String)"{\"volumeAttachment\":{\"volumeId\":\"1\",\"device\":\"/dev/vdc\"}}", (String)"application/json"))).endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        api.attachVolumeToServerAsDevice("1", "instance-1", "/dev/vdc");
    }

    public void testDetachVolume() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/attachment_details.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.detachVolumeFromServer("1", "instance-1"));
    }

    public void testDetachVolumeFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(404).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.detachVolumeFromServer("1", "instance-1"));
    }

    public void testListSnapshots() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-snapshots");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/snapshot_list.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet snapshots = api.listSnapshots().toSet();
        Assert.assertEquals((Set)snapshots, (Set)ImmutableSet.of((Object)this.testSnapshot()));
    }

    public void testListSnapshotsFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-snapshots");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet snapshots = api.listSnapshots().toSet();
        Assert.assertTrue((boolean)snapshots.isEmpty());
    }

    public void testGetSnapshot() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-snapshots/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/snapshot_details.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        VolumeSnapshot snapshot = api.getSnapshot("1");
        Assert.assertEquals((Object)snapshot, (Object)this.testSnapshot());
    }

    public void testGetSnapshotFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-snapshots/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.getSnapshot("1"));
    }

    public void testListSnapshotsInDetail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-snapshots/detail");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/snapshot_list_detail.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet snapshots = api.listSnapshotsInDetail().toSet();
        Assert.assertEquals((Set)snapshots, (Set)ImmutableSet.of((Object)this.testSnapshot()));
        VolumeSnapshot snappy = (VolumeSnapshot)Iterables.getOnlyElement((Iterable)snapshots);
        Assert.assertEquals((String)snappy.getId(), (String)"7");
        Assert.assertEquals((String)snappy.getVolumeId(), (String)"9");
        Assert.assertEquals((Object)snappy.getStatus(), (Object)Volume.Status.AVAILABLE);
        Assert.assertEquals((String)snappy.getDescription(), (String)"jclouds live test snapshot");
        Assert.assertEquals((String)snappy.getName(), (String)"jclouds-live-test");
        Assert.assertEquals((int)snappy.getSize(), (int)1);
    }

    public void testListSnapshotsInDetailFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-snapshots/detail");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet snapshots = api.listSnapshotsInDetail().toSet();
        Assert.assertTrue((boolean)snapshots.isEmpty());
    }

    public void testCreateSnapshot() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-snapshots");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeApiExpectTest.payloadFromStringWithContentType((String)"{\"snapshot\":{\"display_name\":\"jclouds-live-test\",\"volume_id\":\"13\",\"display_description\":\"jclouds live test snapshot\",\"force\":\"true\"}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/snapshot_details.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        VolumeSnapshot snapshot = api.createSnapshot("13", new CreateVolumeSnapshotOptions[]{CreateVolumeSnapshotOptions.Builder.name((String)"jclouds-live-test").description("jclouds live test snapshot").force()});
        Assert.assertEquals((Object)snapshot, (Object)this.testSnapshot());
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testCreateSnapshotFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-snapshots");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeApiExpectTest.payloadFromStringWithContentType((String)"{\"snapshot\":{\"display_name\":\"jclouds-live-test\",\"volume_id\":\"13\",\"display_description\":\"jclouds live test snapshot\",\"force\":\"true\"}}", (String)"application/json"))).build(), HttpResponse.builder().statusCode(401).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        api.createSnapshot("13", new CreateVolumeSnapshotOptions[]{CreateVolumeSnapshotOptions.Builder.name((String)"jclouds-live-test").description("jclouds live test snapshot").force()});
    }

    public void testDeleteSnapshot() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-snapshots/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/snapshot_details.json"))).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.deleteSnapshot("1"));
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testDeleteSnapshotFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-snapshots/1");
        VolumeApi api = (VolumeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(401).build())).getVolumeExtensionForZone("az-1.region-a.geo-1").get();
        api.deleteSnapshot("1");
    }

    protected Volume testVolume() {
        return Volume.builder().status(Volume.Status.IN_USE).description("This is a test volume").zone("nova").name("test").attachments((Set)ImmutableSet.of((Object)this.testAttachment())).size(1).id("1").created(this.dateService.iso8601SecondsDateParse("2012-04-23 12:16:45")).build();
    }

    protected VolumeAttachment testAttachment() {
        return VolumeAttachment.builder().device("/dev/vdc").serverId("b4785058-cb80-491b-baa3-e4ee6546450e").id("1").volumeId("1").build();
    }

    protected VolumeSnapshot testSnapshot() {
        return VolumeSnapshot.builder().id("7").volumeId("9").description("jclouds live test snapshot").status(Volume.Status.AVAILABLE).name("jclouds-live-test").size(1).created(this.dateService.iso8601SecondsDateParse("2012-04-24 13:34:42")).build();
    }
}

