/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Volume;
import org.jclouds.openstack.nova.v2_0.domain.VolumeAttachment;
import org.jclouds.openstack.nova.v2_0.extensions.VolumeAttachmentApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VolumeAttachmentApiExpectTest")
public class VolumeAttachmentApiExpectTest
extends BaseNovaApiExpectTest {
    private DateService dateService = new SimpleDateFormatDateService();

    public void testListAttachments() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments");
        VolumeAttachmentApi api = (VolumeAttachmentApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/attachment_list.json"))).build())).getVolumeAttachmentExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet attachments = api.listAttachmentsOnServer("instance-1").toSet();
        Assert.assertEquals((Set)attachments, (Set)ImmutableSet.of((Object)this.testAttachment()));
        VolumeAttachment attachment = (VolumeAttachment)Iterables.getOnlyElement((Iterable)attachments);
        Assert.assertEquals((String)attachment.getDevice(), (String)"/dev/vdc");
        Assert.assertEquals((String)attachment.getServerId(), (String)"b4785058-cb80-491b-baa3-e4ee6546450e");
        Assert.assertEquals((String)attachment.getId(), (String)"1");
        Assert.assertEquals((String)attachment.getVolumeId(), (String)"1");
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testListAttachmentsFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-2/os-volume_attachments");
        VolumeAttachmentApi api = (VolumeAttachmentApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(401).build())).getVolumeAttachmentExtensionForZone("az-1.region-a.geo-1").get();
        api.listAttachmentsOnServer("instance-2");
    }

    public void testGetAttachment() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments/1");
        VolumeAttachmentApi api = (VolumeAttachmentApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/attachment_details.json"))).build())).getVolumeAttachmentExtensionForZone("az-1.region-a.geo-1").get();
        VolumeAttachment attachment = api.getAttachmentForVolumeOnServer("1", "instance-1");
        Assert.assertEquals((Object)attachment, (Object)this.testAttachment());
    }

    public void testGetAttachmentFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments/1");
        VolumeAttachmentApi api = (VolumeAttachmentApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeAttachmentExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.getAttachmentForVolumeOnServer("1", "instance-1"));
    }

    public void testAttachVolume() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments");
        VolumeAttachmentApi api = (VolumeAttachmentApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeAttachmentApiExpectTest.payloadFromStringWithContentType((String)"{\"volumeAttachment\":{\"volumeId\":\"1\",\"device\":\"/dev/vdc\"}}", (String)"application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/attachment_details.json"))).build())).getVolumeAttachmentExtensionForZone("az-1.region-a.geo-1").get();
        VolumeAttachment result = api.attachVolumeToServerAsDevice("1", "instance-1", "/dev/vdc");
        Assert.assertEquals((Object)result, (Object)this.testAttachment());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testAttachVolumeFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments");
        VolumeAttachmentApi api = (VolumeAttachmentApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeAttachmentApiExpectTest.payloadFromStringWithContentType((String)"{\"volumeAttachment\":{\"volumeId\":\"1\",\"device\":\"/dev/vdc\"}}", (String)"application/json"))).endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeAttachmentExtensionForZone("az-1.region-a.geo-1").get();
        api.attachVolumeToServerAsDevice("1", "instance-1", "/dev/vdc");
    }

    public void testDetachVolume() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments/1");
        VolumeAttachmentApi api = (VolumeAttachmentApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/attachment_details.json"))).build())).getVolumeAttachmentExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.detachVolumeFromServer("1", "instance-1"));
    }

    public void testDetachVolumeFail() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/instance-1/os-volume_attachments/1");
        VolumeAttachmentApi api = (VolumeAttachmentApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(404).build())).getVolumeAttachmentExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.detachVolumeFromServer("1", "instance-1"));
    }

    protected Volume testVolume() {
        return Volume.builder().status(Volume.Status.IN_USE).description("This is a test volume").zone("nova").name("test").attachments((Set)ImmutableSet.of((Object)this.testAttachment())).size(1).id("1").created(this.dateService.iso8601SecondsDateParse("2012-04-23 12:16:45")).build();
    }

    protected VolumeAttachment testAttachment() {
        return VolumeAttachment.builder().device("/dev/vdc").serverId("b4785058-cb80-491b-baa3-e4ee6546450e").id("1").volumeId("1").build();
    }
}

