/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Volume;
import org.jclouds.openstack.nova.v2_0.domain.VolumeAttachment;
import org.jclouds.openstack.nova.v2_0.extensions.VolumeApi;
import org.jclouds.openstack.nova.v2_0.extensions.VolumeAttachmentApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.jclouds.openstack.nova.v2_0.options.CreateVolumeOptions;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="VolumeAttachmentApiLiveTest", singleThreaded=true)
public class VolumeAttachmentApiLiveTest
extends BaseNovaApiLiveTest {
    private Optional<? extends VolumeApi> volumeApi;
    private Optional<? extends VolumeAttachmentApi> volumeAttachmentApi;
    private String zone;
    private Volume testVolume;

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
        this.volumeApi = ((NovaApi)this.api).getVolumeExtensionForZone(this.zone);
        this.volumeAttachmentApi = ((NovaApi)this.api).getVolumeAttachmentExtensionForZone(this.zone);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.volumeApi.isPresent() && this.testVolume != null) {
            final String volumeId = this.testVolume.getId();
            Assert.assertTrue((boolean)((VolumeApi)this.volumeApi.get()).delete(volumeId));
            Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeApi>(){

                public boolean apply(VolumeApi volumeApi) {
                    return volumeApi.get(volumeId) == null;
                }
            }, (long)180000L).apply(this.volumeApi.get()));
        }
        super.tearDown();
    }

    public void testCreateVolume() {
        if (this.volumeApi.isPresent()) {
            CreateVolumeOptions options = CreateVolumeOptions.Builder.name((String)"jclouds-test-volume").description("description of test volume").availabilityZone(this.zone);
            this.testVolume = ((VolumeApi)this.volumeApi.get()).create(1, new CreateVolumeOptions[]{options});
            Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeApi>(){

                public boolean apply(VolumeApi volumeApi) {
                    return volumeApi.get(VolumeAttachmentApiLiveTest.this.testVolume.getId()).getStatus() == Volume.Status.AVAILABLE;
                }
            }, (long)180000L).apply(this.volumeApi.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testCreateVolume"})
    public void testAttachments() {
        if (this.volumeApi.isPresent()) {
            String server_id = null;
            try {
                final String serverId = server_id = this.createServerInZone(this.zone).getId();
                ImmutableSet attachments = ((VolumeAttachmentApi)this.volumeAttachmentApi.get()).listAttachmentsOnServer(serverId).toSet();
                Assert.assertNotNull((Object)attachments);
                final int before = attachments.size();
                VolumeAttachment testAttachment = ((VolumeAttachmentApi)this.volumeAttachmentApi.get()).attachVolumeToServerAsDevice(this.testVolume.getId(), serverId, "/dev/vdf");
                Assert.assertNotNull((Object)testAttachment.getId());
                Assert.assertEquals((String)testAttachment.getVolumeId(), (String)this.testVolume.getId());
                Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeAttachmentApi>(){

                    public boolean apply(VolumeAttachmentApi volumeAttachmentApi) {
                        return volumeAttachmentApi.listAttachmentsOnServer(serverId).size() > before;
                    }
                }, (long)60000L).apply(this.volumeAttachmentApi.get()));
                attachments = ((VolumeAttachmentApi)this.volumeAttachmentApi.get()).listAttachmentsOnServer(serverId).toSet();
                Assert.assertNotNull((Object)attachments);
                Assert.assertEquals((int)attachments.size(), (int)(before + 1));
                Assert.assertEquals((Object)((VolumeApi)this.volumeApi.get()).get(this.testVolume.getId()).getStatus(), (Object)Volume.Status.IN_USE);
                boolean foundIt = false;
                for (VolumeAttachment att : attachments) {
                    VolumeAttachment details = ((VolumeAttachmentApi)this.volumeAttachmentApi.get()).getAttachmentForVolumeOnServer(att.getVolumeId(), serverId);
                    Assert.assertNotNull((Object)details);
                    Assert.assertNotNull((Object)details.getId());
                    Assert.assertNotNull((Object)details.getServerId());
                    Assert.assertNotNull((Object)details.getVolumeId());
                    if (!Objects.equal((Object)details.getVolumeId(), (Object)this.testVolume.getId())) continue;
                    foundIt = true;
                    Assert.assertEquals((String)details.getDevice(), (String)"/dev/vdf");
                    Assert.assertEquals((String)details.getServerId(), (String)serverId);
                }
                Assert.assertTrue((boolean)foundIt, (String)"Failed to find the attachment we created in listAttachments() response");
                ((VolumeAttachmentApi)this.volumeAttachmentApi.get()).detachVolumeFromServer(this.testVolume.getId(), serverId);
                Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<VolumeAttachmentApi>(){

                    public boolean apply(VolumeAttachmentApi volumeAttachmentApi) {
                        return volumeAttachmentApi.listAttachmentsOnServer(serverId).size() == before;
                    }
                }, (long)60000L).apply(this.volumeAttachmentApi.get()));
            }
            finally {
                if (server_id != null) {
                    ((NovaApi)this.api).getServerApiForZone(this.zone).delete(server_id);
                }
            }
        }
    }
}

