/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.VolumeType;
import org.jclouds.openstack.nova.v2_0.extensions.VolumeTypeApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.options.CreateVolumeTypeOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VolumeTypeApiExpectTest")
public class VolumeTypeApiExpectTest
extends BaseNovaApiExpectTest {
    private DateService dateService = new SimpleDateFormatDateService();

    public void testListVolumeTypes() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_type_list.json"))).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        ImmutableSet types = api.list().toSet();
        Assert.assertEquals((Set)types, (Set)ImmutableSet.of((Object)this.testVolumeType()));
    }

    public void testGetVolumeType() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/8");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_type.json"))).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        VolumeType type = api.get("8");
        Assert.assertEquals((Object)type, (Object)this.testVolumeType());
    }

    public void testGetVolumeTypeFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/8");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.get("8"));
    }

    public void testCreateVolumeType() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeTypeApiExpectTest.payloadFromStringWithContentType((String)"{\"volume_type\":{\"name\":\"jclouds-test-1\"}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_type.json"))).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        VolumeType type = api.create("jclouds-test-1", new CreateVolumeTypeOptions[0]);
        Assert.assertEquals((Object)type, (Object)this.testVolumeType());
    }

    public void testCreateVolumeTypeWithOptsNONE() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeTypeApiExpectTest.payloadFromStringWithContentType((String)"{\"volume_type\":{\"name\":\"jclouds-test-1\",\"extra_specs\":{}}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_type.json"))).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        VolumeType type = api.create("jclouds-test-1", new CreateVolumeTypeOptions[]{CreateVolumeTypeOptions.NONE});
        Assert.assertEquals((Object)type, (Object)this.testVolumeType());
    }

    public void testCreateVolumeTypeWithOptsSet() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeTypeApiExpectTest.payloadFromStringWithContentType((String)"{\"volume_type\":{\"name\":\"jclouds-test-1\",\"extra_specs\":{\"x\": \"y\"}}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_type.json"))).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        VolumeType type = api.create("jclouds-test-1", new CreateVolumeTypeOptions[]{CreateVolumeTypeOptions.Builder.specs((Map)ImmutableMap.of((Object)"x", (Object)"y"))});
        Assert.assertEquals((Object)type, (Object)this.testVolumeType());
    }

    public void testDeleteVolumeType() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/8");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(200).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.delete("8"));
    }

    public void testDeleteVolumeTypeFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/8");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(404).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.delete("8"));
    }

    public void testGetAllExtraSpecs() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/9/extra_specs");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_type_extra_specs.json"))).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Map)api.getExtraSpecs("9"), (Map)ImmutableMap.of((Object)"test", (Object)"value1"));
    }

    public void testGetAllExtraSpecsFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/9/extra_specs");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.getExtraSpecs("9").isEmpty());
    }

    public void testSetAllExtraSpecs() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/9/extra_specs");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(VolumeTypeApiExpectTest.payloadFromStringWithContentType((String)"{\"extra_specs\":{\"test1\":\"somevalue\"}}", (String)"application/json"))).build(), HttpResponse.builder().statusCode(200).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.updateExtraSpecs("9", (Map)ImmutableMap.of((Object)"test1", (Object)"somevalue")));
    }

    public void testSetExtraSpec() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/5/extra_specs/test1");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("PUT").payload(VolumeTypeApiExpectTest.payloadFromStringWithContentType((String)"{\"test1\":\"somevalue\"}", (String)"application/json"))).build(), HttpResponse.builder().statusCode(200).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.updateExtraSpec("5", "test1", "somevalue"));
    }

    public void testGetExtraSpec() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/5/extra_specs/test1");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(VolumeTypeApiExpectTest.payloadFromStringWithContentType((String)"{\"test1\":\"another value\"}", (String)"application/json"))).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((String)api.getExtraSpec("5", "test1"), (String)"another value");
    }

    public void testGetExtraSpecFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/5/extra_specs/test1");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.getExtraSpec("5", "test1"));
    }

    public void testDeleteExtraSpec() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/5/extra_specs/test1");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(200).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.deleteExtraSpec("5", "test1"));
    }

    public void testDeleteExtraSpecFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-volume-types/5/extra_specs/test1");
        VolumeTypeApi api = (VolumeTypeApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(404).build())).getVolumeTypeExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.deleteExtraSpec("5", "test1"));
    }

    public VolumeType testVolumeType() {
        return VolumeType.builder().id("8").name("jclouds-test-1").created(this.dateService.iso8601SecondsDateParse("2012-05-10 12:33:06")).extraSpecs((Map)ImmutableMap.of((Object)"test", (Object)"value1", (Object)"test1", (Object)"wibble")).build();
    }
}

