/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseExtensionListTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseExtensionTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ExtensionApiExpectTest")
public class ExtensionApiExpectTest
extends BaseNovaApiExpectTest {
    public void testListExtensionsWhenResponseIs2xx() throws Exception {
        HttpRequest listExtensions = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/extensions").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listExtensionsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/extension_list.json"))).build();
        NovaApi apiWhenExtensionsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, listExtensions, listExtensionsResponse);
        Assert.assertEquals((Set)apiWhenExtensionsExist.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-1.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-3.region-a.geo-1"));
        Assert.assertEquals((String)apiWhenExtensionsExist.getExtensionApiForZone("az-1.region-a.geo-1").list().toString(), (String)new ParseExtensionListTest().expected().toString());
    }

    public void testListExtensionsWhenReponseIs404IsEmpty() throws Exception {
        HttpRequest listExtensions = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/extensions").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listExtensionsResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, listExtensions, listExtensionsResponse);
        Assert.assertTrue((boolean)apiWhenNoServersExist.getExtensionApiForZone("az-1.region-a.geo-1").list().isEmpty());
    }

    public void testGetExtensionByAliasWhenResponseIs2xx() throws Exception {
        HttpRequest getExtension = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/extensions/RS-PIE").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getExtensionResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/extension_details.json"))).build();
        NovaApi apiWhenExtensionsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getExtension, getExtensionResponse);
        Assert.assertEquals((String)apiWhenExtensionsExist.getExtensionApiForZone("az-1.region-a.geo-1").get("RS-PIE").toString(), (String)new ParseExtensionTest().expected().toString());
    }

    public void testGetExtensionByAliasWhenResponseIs404() throws Exception {
        HttpRequest getExtension = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/extensions/RS-PIE").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getExtensionResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResource("/extension_details.json"))).build();
        NovaApi apiWhenNoExtensionsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getExtension, getExtensionResponse);
        Assert.assertNull((Object)apiWhenNoExtensionsExist.getExtensionApiForZone("az-1.region-a.geo-1").get("RS-PIE"));
    }
}

