/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import java.util.Set;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.jclouds.openstack.v2_0.domain.Extension;
import org.jclouds.openstack.v2_0.features.ExtensionApi;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ExtensionApiLiveTest")
public class ExtensionApiLiveTest
extends BaseNovaApiLiveTest {
    @Test(description="GET /v${apiVersion}/{tenantId}/extensions")
    public void testListExtensions() throws Exception {
        for (String zoneId : this.zones) {
            ExtensionApi extensionApi = ((NovaApi)this.api).getExtensionApiForZone(zoneId);
            Set response = extensionApi.list();
            Assert.assertNotNull((Object)response);
            Assert.assertFalse((boolean)response.isEmpty());
            for (Extension extension : response) {
                Assert.assertNotNull((Object)extension.getId());
                Assert.assertNotNull((Object)extension.getName());
                Assert.assertNotNull((Object)extension.getDescription());
                Assert.assertNotNull((Object)extension.getNamespace());
                Assert.assertNotNull((Object)extension.getUpdated());
                Assert.assertNotNull((Object)extension.getLinks());
            }
        }
    }

    @Test(description="GET /v${apiVersion}/{tenantId}/extensions/{alias}", dependsOnMethods={"testListExtensions"})
    public void testGetExtensionByAlias() throws Exception {
        for (String zoneId : this.zones) {
            ExtensionApi extensionApi = ((NovaApi)this.api).getExtensionApiForZone(zoneId);
            Set response = extensionApi.list();
            for (Extension extension : response) {
                Extension details = extensionApi.get(extension.getId());
                Assert.assertNotNull((Object)details);
                Assert.assertEquals((String)details.getId(), (String)extension.getId());
                Assert.assertEquals((String)details.getName(), (String)extension.getName());
                Assert.assertEquals((String)details.getDescription(), (String)extension.getDescription());
                Assert.assertEquals((Object)details.getNamespace(), (Object)extension.getNamespace());
                Assert.assertEquals((Object)details.getUpdated(), (Object)extension.getUpdated());
                Assert.assertEquals((Set)details.getLinks(), (Set)extension.getLinks());
            }
        }
    }
}

