/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseCreateFlavorTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseFlavorListTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseFlavorTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FlavorApiExpectTest")
public class FlavorApiExpectTest
extends BaseNovaApiExpectTest {
    public void testListFlavorsWhenResponseIs2xx() throws Exception {
        HttpRequest listFlavors = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listFlavorsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/flavor_list.json"))).build();
        NovaApi apiWhenFlavorsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, listFlavors, listFlavorsResponse);
        Assert.assertEquals((Set)apiWhenFlavorsExist.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-1.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-3.region-a.geo-1"));
        Assert.assertEquals((String)apiWhenFlavorsExist.getFlavorApiForZone("az-1.region-a.geo-1").list().concat().toString(), (String)new ParseFlavorListTest().expected().toString());
    }

    public void testListFlavorsWhenReponseIs404IsEmpty() throws Exception {
        HttpRequest listFlavors = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listFlavorsResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, listFlavors, listFlavorsResponse);
        Assert.assertTrue((boolean)apiWhenNoServersExist.getFlavorApiForZone("az-1.region-a.geo-1").list().concat().isEmpty());
    }

    public void testGetFlavorWhenResponseIs2xx() throws Exception {
        HttpRequest getFlavor = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/52415800-8b69-11e0-9b19-734f1195ff37").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getFlavorResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/flavor_details.json"))).build();
        NovaApi apiWhenFlavorsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getFlavor, getFlavorResponse);
        Assert.assertEquals((String)apiWhenFlavorsExist.getFlavorApiForZone("az-1.region-a.geo-1").get("52415800-8b69-11e0-9b19-734f1195ff37").toString(), (String)new ParseFlavorTest().expected().toString());
    }

    public void testGetFlavorWhenResponseIs404() throws Exception {
        HttpRequest getFlavor = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/123").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getFlavorResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResource("/flavor_details.json"))).build();
        NovaApi apiWhenNoFlavorsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getFlavor, getFlavorResponse);
        Assert.assertNull((Object)apiWhenNoFlavorsExist.getFlavorApiForZone("az-1.region-a.geo-1").get("123"));
    }

    public void testCreateFlavor200() throws Exception {
        ParseCreateFlavorTest parser = new ParseCreateFlavorTest();
        HttpRequest listFlavors = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(this.payloadFromResource(parser.resource()))).build();
        HttpResponse listFlavorsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource(parser.resource()))).build();
        NovaApi api = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, listFlavors, listFlavorsResponse);
        Assert.assertEquals((String)api.getFlavorApiForZone("az-1.region-a.geo-1").create(((Flavor.Builder)((Flavor.Builder)Flavor.builder().id("1cb47a44-9b84-4da4-bf81-c1976e8414ab")).name("128 MB Server")).ram(128).vcpus(1).disk(10).build()).toString(), (String)parser.expected().toString());
    }

    public void testDeleteFlavor202() throws Exception {
        String flavorId = "1cb47a44-9b84-4da4-bf81-c1976e8414ab";
        HttpRequest updateMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/" + flavorId).addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse updateMetadataResponse = HttpResponse.builder().statusCode(204).build();
        NovaApi api = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, updateMetadata, updateMetadataResponse);
        api.getFlavorApiForZone("az-1.region-a.geo-1").delete(flavorId);
    }
}

