/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.features.FlavorApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="FlavorApiLiveTest")
public class FlavorApiLiveTest
extends BaseNovaApiLiveTest {
    @Test(description="GET /v${apiVersion}/{tenantId}/flavors")
    public void testListFlavors() throws Exception {
        for (String zoneId : this.zones) {
            FlavorApi flavorApi = ((NovaApi)this.api).getFlavorApiForZone(zoneId);
            ImmutableSet response = flavorApi.list().concat().toSet();
            Assert.assertNotNull((Object)response);
            Assert.assertFalse((boolean)response.isEmpty());
            for (Resource flavor : response) {
                Assert.assertNotNull((Object)flavor.getId());
                Assert.assertNotNull((Object)flavor.getName());
                Assert.assertNotNull((Object)flavor.getLinks());
            }
        }
    }

    @Test(description="GET /v${apiVersion}/{tenantId}/flavors/detail")
    public void testListFlavorsInDetail() throws Exception {
        for (String zoneId : this.zones) {
            FlavorApi flavorApi = ((NovaApi)this.api).getFlavorApiForZone(zoneId);
            ImmutableSet response = flavorApi.listInDetail().concat().toSet();
            Assert.assertNotNull((Object)response);
            Assert.assertFalse((boolean)response.isEmpty());
            for (Flavor flavor : response) {
                Assert.assertNotNull((Object)flavor.getId());
                Assert.assertNotNull((Object)flavor.getName());
                Assert.assertNotNull((Object)flavor.getLinks());
                Assert.assertTrue((flavor.getRam() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((flavor.getDisk() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((flavor.getVcpus() > 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test(description="GET /v${apiVersion}/{tenantId}/flavors/{id}", dependsOnMethods={"testListFlavorsInDetail"})
    public void testGetFlavorById() throws Exception {
        for (String zoneId : this.zones) {
            FlavorApi flavorApi = ((NovaApi)this.api).getFlavorApiForZone(zoneId);
            ImmutableSet response = flavorApi.listInDetail().concat().toSet();
            for (Flavor flavor : response) {
                Flavor details = flavorApi.get(flavor.getId());
                Assert.assertNotNull((Object)details);
                Assert.assertEquals((String)details.getId(), (String)flavor.getId());
                Assert.assertEquals((String)details.getName(), (String)flavor.getName());
                Assert.assertEquals((Set)details.getLinks(), (Set)flavor.getLinks());
                Assert.assertEquals((int)details.getRam(), (int)flavor.getRam());
                Assert.assertEquals((int)details.getDisk(), (int)flavor.getDisk());
                Assert.assertEquals((int)details.getVcpus(), (int)flavor.getVcpus());
            }
        }
    }
}

