/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseImageListTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseImageTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseMetadataListTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseMetadataUpdateTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ImageAsyncApiTest")
public class ImageApiExpectTest
extends BaseNovaApiExpectTest {
    public void testListImagesWhenResponseIs2xx() throws Exception {
        HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/image_list.json"))).build();
        NovaApi apiWhenImagesExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, list, listResponse);
        Assert.assertEquals((Set)apiWhenImagesExist.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-1.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-3.region-a.geo-1"));
        Assert.assertEquals((String)apiWhenImagesExist.getImageApiForZone("az-1.region-a.geo-1").list().concat().toString(), (String)new ParseImageListTest().expected().toString());
    }

    public void testListImagesWhenReponseIs404IsEmpty() throws Exception {
        HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, list, listResponse);
        Assert.assertTrue((boolean)apiWhenNoServersExist.getImageApiForZone("az-1.region-a.geo-1").list().concat().isEmpty());
    }

    public void testGetImageWhenResponseIs2xx() throws Exception {
        HttpRequest getImage = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/52415800-8b69-11e0-9b19-734f5736d2a2").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getImageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/image_details.json"))).build();
        NovaApi apiWhenImagesExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getImage, getImageResponse);
        Assert.assertEquals((String)apiWhenImagesExist.getImageApiForZone("az-1.region-a.geo-1").get("52415800-8b69-11e0-9b19-734f5736d2a2").toString(), (String)new ParseImageTest().expected().toString());
    }

    public void testGetImageWhenResponseIs404() throws Exception {
        HttpRequest getImage = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/52415800-8b69-11e0-9b19-734f5736d2a2").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getImageResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoImagesExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getImage, getImageResponse);
        Assert.assertNull((Object)apiWhenNoImagesExist.getImageApiForZone("az-1.region-a.geo-1").get("52415800-8b69-11e0-9b19-734f5736d2a2"));
    }

    public void testListMetadataWhenResponseIs2xx() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        HttpRequest getMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/metadata_list.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getMetadata, getMetadataResponse);
        Assert.assertEquals((String)apiWhenServerExists.getImageApiForZone("az-1.region-a.geo-1").getMetadata(imageId).toString(), (String)new ParseMetadataListTest().expected().toString());
    }

    public void testListMetadataWhenResponseIs404() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        HttpRequest getMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId + "/metadata").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getMetadataResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getMetadata, getMetadataResponse);
        try {
            apiWhenServerExists.getImageApiForZone("az-1.region-a.geo-1").getMetadata(imageId);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testSetMetadataWhenResponseIs2xx() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 1").put((Object)"Image Version", (Object)"2.1").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ImageApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 1\",\"Image Version\":\"2.1\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/metadata_list.json"))).build();
        NovaApi apiWhenImageExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        Assert.assertEquals((String)apiWhenImageExists.getImageApiForZone("az-1.region-a.geo-1").setMetadata(imageId, (Map)metadata).toString(), (String)new ParseMetadataListTest().expected().toString());
    }

    public void testSetMetadataWhenResponseIs404() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 1").put((Object)"Image Version", (Object)"2.1").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId + "/metadata").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ImageApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 1\",\"Image Version\":\"2.1\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        try {
            apiWhenServerExists.getImageApiForZone("az-1.region-a.geo-1").setMetadata(imageId, (Map)metadata);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testUpdateMetadataWhenResponseIs2xx() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 2").put((Object)"Server Description", (Object)"Simple Server").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ImageApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 2\",\"Server Description\":\"Simple Server\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/metadata_updated.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        Assert.assertEquals((String)apiWhenServerExists.getImageApiForZone("az-1.region-a.geo-1").updateMetadata(imageId, (Map)metadata).toString(), (String)new ParseMetadataUpdateTest().expected().toString());
    }

    public void testUpdateMetadataWhenResponseIs404() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        ImmutableMap metadata = new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 2").put((Object)"Server Description", (Object)"Simple Server").build();
        HttpRequest setMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/" + imageId + "/metadata").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ImageApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Server Label\":\"Web Head 2\",\"Server Description\":\"Simple Server\"}}", (String)"application/json"))).build();
        HttpResponse setMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResource("/metadata_updated.json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, setMetadata, setMetadataResponse);
        try {
            apiWhenServerExists.getImageApiForZone("az-1.region-a.geo-1").setMetadata(imageId, (Map)metadata);
            Assert.fail((String)"Expected an exception.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testGetMetadataItemWhenResponseIs2xx() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        String key = "Image%20Version";
        HttpRequest getMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId + "/metadata/" + key).addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(ImageApiExpectTest.payloadFromString((String)"{\"metadata\":{\"Image Version\":\"2.5\"}}"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getMetadata, getMetadataResponse);
        Assert.assertEquals((String)apiWhenServerExists.getImageApiForZone("az-1.region-a.geo-1").getMetadata(imageId, "Image Version").toString(), (String)"2.5");
    }

    public void testGetMetadataItemWhenResponseIs404() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        String key = "Image%20Version";
        HttpRequest getMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId + "/metadata/" + key).addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse getMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(ImageApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Image Version\":\"2.5\"}}", (String)"application/json"))).build();
        NovaApi apiWhenImageExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, getMetadata, getMetadataResponse);
        Assert.assertNull((Object)apiWhenImageExists.getImageApiForZone("az-1.region-a.geo-1").getMetadata(imageId, key));
    }

    public void testSetMetadataItemWhenResponseIs2xx() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        String key = "Image Version";
        HttpRequest updateMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId + "/metadata/" + "Image%20Version").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(ImageApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Image Version\":\"2.5\"}}", (String)"application/json"))).build();
        HttpResponse updateMetadataResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(ImageApiExpectTest.payloadFromStringWithContentType((String)"{\"metadata\":{\"Image Version\":\"2.5\"}}", (String)"application/json"))).build();
        NovaApi apiWhenServerExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, updateMetadata, updateMetadataResponse);
        Assert.assertEquals((String)apiWhenServerExists.getImageApiForZone("az-1.region-a.geo-1").updateMetadata(imageId, key, "2.5").toString(), (String)"2.5");
    }

    public void testDeleteMetadataItemWhenResponseIs2xx() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        String key = "Image%20Version";
        HttpRequest deleteMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId + "/metadata/" + key).addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse deleteMetadataResponse = HttpResponse.builder().statusCode(204).build();
        NovaApi apiWhenImageExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, deleteMetadata, deleteMetadataResponse);
        apiWhenImageExists.getImageApiForZone("az-1.region-a.geo-1").deleteMetadata(imageId, key);
    }

    public void testDeleteMetadataItemWhenResponseIs404() throws Exception {
        String imageId = "52415800-8b69-11e0-9b19-734f5736d2a2";
        String key = "Image%20Version";
        HttpRequest deleteMetadata = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/" + imageId + "/metadata/" + key).addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse deleteMetadataResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenImageExists = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, deleteMetadata, deleteMetadataResponse);
        apiWhenImageExists.getImageApiForZone("az-1.region-a.geo-1").deleteMetadata(imageId, key);
    }
}

