/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.predicates.LinkPredicates;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ServerApiLiveTest")
public class ServerApiLiveTest
extends BaseNovaApiLiveTest {
    @Test(description="GET /v${apiVersion}/{tenantId}/servers")
    public void testListServers() throws Exception {
        for (String zoneId : this.zones) {
            ServerApi serverApi = ((NovaApi)this.api).getServerApiForZone(zoneId);
            for (Resource server : serverApi.list().concat()) {
                this.checkResource(server);
            }
        }
    }

    @Test(description="GET /v${apiVersion}/{tenantId}/servers/detail")
    public void testListServersInDetail() throws Exception {
        for (String zoneId : this.zones) {
            ServerApi serverApi = ((NovaApi)this.api).getServerApiForZone(zoneId);
            for (Server server : serverApi.listInDetail().concat()) {
                this.checkServer(server);
            }
        }
    }

    @Test(description="GET /v${apiVersion}/{tenantId}/servers/{id}", dependsOnMethods={"testListServersInDetail"})
    public void testGetServerById() throws Exception {
        for (String zoneId : this.zones) {
            ServerApi serverApi = ((NovaApi)this.api).getServerApiForZone(zoneId);
            for (Resource server : serverApi.list().concat()) {
                Server details = serverApi.get(server.getId());
                Assert.assertEquals((String)details.getId(), (String)server.getId());
                Assert.assertEquals((String)details.getName(), (String)server.getName());
                Assert.assertEquals((Set)details.getLinks(), (Set)server.getLinks());
                this.checkServer(details);
            }
        }
    }

    private void checkResource(Resource resource) {
        Assert.assertNotNull((Object)resource.getId());
        Assert.assertNotNull((Object)resource.getName());
        Assert.assertNotNull((Object)resource.getLinks());
        Assert.assertTrue((boolean)Iterables.any((Iterable)resource.getLinks(), (Predicate)LinkPredicates.relationEquals((Link.Relation)Link.Relation.SELF)));
    }

    private void checkServer(Server server) {
        this.checkResource((Resource)server);
        Assert.assertFalse((boolean)server.getAddresses().isEmpty());
    }
}

