/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.CreateSecurityGroupIfNeeded;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseComputeServiceTypicalSecurityGroupTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CreateSecurityGroupIfNeededTest")
public class CreateSecurityGroupIfNeededTest
extends BaseNovaApiExpectTest {
    HttpRequest create;

    public CreateSecurityGroupIfNeededTest() {
        this.create = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).payload(CreateSecurityGroupIfNeededTest.payloadFromStringWithContentType((String)"{\"security_group\":{\"name\":\"jclouds_mygroup\",\"description\":\"jclouds_mygroup\"}}", (String)"application/json"))).build();
    }

    public void testCreateNewGroup() throws Exception {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)this.responseWithKeystoneAccess);
        builder.put((Object)this.extensionsOfNovaRequest, (Object)this.extensionsOfNovaResponse);
        int groupId = 2769;
        HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(CreateSecurityGroupIfNeededTest.payloadFromStringWithContentType((String)String.format("{\"security_group\": {\"rules\": [], \"tenant_id\": \"37936628937291\", \"id\": %s, \"name\": \"jclouds_mygroup\", \"description\": \"jclouds_mygroup\"}}", groupId), (String)"application/json; charset=UTF-8"))).build();
        builder.put((Object)this.create, (Object)createResponse);
        int ruleId = 10331;
        Iterator i$ = ImmutableList.of((Object)22, (Object)8080).iterator();
        while (i$.hasNext()) {
            int port = (Integer)i$.next();
            HttpRequest createCidrRule = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-group-rules")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).payload(CreateSecurityGroupIfNeededTest.payloadFromStringWithContentType((String)String.format("{\"security_group_rule\":{\"parent_group_id\":\"%s\",\"cidr\":\"0.0.0.0/0\",\"ip_protocol\":\"tcp\",\"from_port\":\"%d\",\"to_port\":\"%d\"}}", groupId, port, port), (String)"application/json"))).build();
            HttpResponse createCidrRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(CreateSecurityGroupIfNeededTest.payloadFromStringWithContentType((String)String.format("{\"security_group_rule\": {\"from_port\": %d, \"group\": {}, \"ip_protocol\": \"tcp\", \"to_port\": %d, \"parent_group_id\": %d, \"ip_range\": {\"cidr\": \"0.0.0.0/0\"}, \"id\": %d}}", port, port, groupId, ruleId++), (String)"application/json; charset=UTF-8"))).build();
            builder.put((Object)createCidrRule, (Object)createCidrRuleResponse);
            HttpRequest createSelfRule = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-group-rules")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).payload(CreateSecurityGroupIfNeededTest.payloadFromStringWithContentType((String)String.format("{\"security_group_rule\":{\"group_id\":\"%d\",\"parent_group_id\":\"%d\",\"ip_protocol\":\"tcp\",\"from_port\":\"%d\",\"to_port\":\"%d\"}}", groupId, groupId, port, port), (String)"application/json"))).build();
            HttpResponse createSelfRuleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(CreateSecurityGroupIfNeededTest.payloadFromStringWithContentType((String)String.format("{\"security_group_rule\": {\"from_port\": %d, \"group\": {\"tenant_id\": \"37936628937291\", \"name\": \"jclouds_mygroup\"}, \"ip_protocol\": \"tcp\", \"to_port\": %d, \"parent_group_id\": %d, \"ip_range\": {}, \"id\": %d}}", port, port, groupId, ruleId++), (String)"application/json; charset=UTF-8"))).build();
            builder.put((Object)createSelfRule, (Object)createSelfRuleResponse);
        }
        HttpRequest getSecurityGroup = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups/" + groupId)).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse getSecurityGroupResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygroup_details_computeservice_typical.json"))).build();
        builder.put((Object)getSecurityGroup, (Object)getSecurityGroupResponse);
        NovaApi apiCanCreateSecurityGroup = (NovaApi)this.requestsSendResponses((Map)builder.build());
        CreateSecurityGroupIfNeeded fn = new CreateSecurityGroupIfNeeded(apiCanCreateSecurityGroup);
        Assert.assertEquals((String)fn.apply(new ZoneSecurityGroupNameAndPorts("az-1.region-a.geo-1", "jclouds_mygroup", (Iterable)ImmutableSet.of((Object)22, (Object)8080))).toString(), (String)new SecurityGroupInZone(new ParseComputeServiceTypicalSecurityGroupTest().expected(), "az-1.region-a.geo-1").toString());
    }

    public void testReturnExistingGroupOnAlreadyExists() throws Exception {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)this.responseWithKeystoneAccess);
        builder.put((Object)this.extensionsOfNovaRequest, (Object)this.extensionsOfNovaResponse);
        HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).payload(CreateSecurityGroupIfNeededTest.payloadFromStringWithContentType((String)"{\"badRequest\": {\"message\": \"Security group test already exists\", \"code\": 400}}", (String)"application/json; charset=UTF-8"))).build();
        builder.put((Object)this.create, (Object)createResponse);
        HttpRequest list = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygroup_list_details_computeservice_typical.json"))).build();
        builder.put((Object)list, (Object)listResponse);
        NovaApi apiWhenSecurityGroupsExist = (NovaApi)this.requestsSendResponses((Map)builder.build());
        CreateSecurityGroupIfNeeded fn = new CreateSecurityGroupIfNeeded(apiWhenSecurityGroupsExist);
        Assert.assertEquals((String)fn.apply(new ZoneSecurityGroupNameAndPorts("az-1.region-a.geo-1", "jclouds_mygroup", (Iterable)ImmutableSet.of((Object)22, (Object)8080))).toString(), (String)new SecurityGroupInZone(new ParseComputeServiceTypicalSecurityGroupTest().expected(), "az-1.region-a.geo-1").toString());
    }
}

