/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerCreated;
import org.jclouds.openstack.nova.v2_0.domain.ServerExtendedStatus;
import org.jclouds.openstack.nova.v2_0.features.FlavorApi;
import org.jclouds.openstack.nova.v2_0.features.ImageApi;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.jclouds.openstack.nova.v2_0.options.CreateServerOptions;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BaseNovaApiLiveTest
extends BaseApiLiveTest<NovaApi> {
    protected String hostName = System.getProperty("user.name").replace('.', '-').toLowerCase();
    protected Set<String> zones;
    static final Ordering<Flavor> DEFAULT_FLAVOR_ORDERING = new Ordering<Flavor>(){

        public int compare(Flavor left, Flavor right) {
            return ComparisonChain.start().compare(left.getVcpus(), right.getVcpus()).compare(left.getRam(), right.getRam()).compare(left.getDisk(), right.getDisk()).result();
        }
    };

    public BaseNovaApiLiveTest() {
        this.provider = "openstack-nova";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zones = ((NovaApi)this.api).getConfiguredZones();
        for (String zone : this.zones) {
            ServerApi serverApi = ((NovaApi)this.api).getServerApiForZone(zone);
            for (Resource server : serverApi.list().concat()) {
                if (!server.getName().equals(this.hostName)) continue;
                serverApi.delete(server.getId());
            }
        }
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        this.setIfTestSystemPropertyPresent(props, "jclouds.keystone.credential-type");
        this.setIfTestSystemPropertyPresent(props, "jclouds.openstack-nova.auto-create-floating-ips");
        return props;
    }

    protected Server createServerInZone(String zoneId) {
        ServerApi serverApi = ((NovaApi)this.api).getServerApiForZone(zoneId);
        ServerCreated server = serverApi.create(this.hostName, this.imageIdForZone(zoneId), this.flavorRefForZone(zoneId), new CreateServerOptions[0]);
        this.blockUntilServerInState(server.getId(), serverApi, Server.Status.ACTIVE);
        return serverApi.get(server.getId());
    }

    protected void blockUntilServerInState(String serverId, ServerApi api, Server.Status status) {
        Server currentDetails = null;
        currentDetails = api.get(serverId);
        while (currentDetails.getStatus() != status || currentDetails.getExtendedStatus().isPresent() && ((ServerExtendedStatus)currentDetails.getExtendedStatus().get()).getTaskState() != null) {
            System.out.printf("blocking on status %s%n%s%n", status, currentDetails);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
            currentDetails = api.get(serverId);
        }
    }

    protected String imageIdForZone(String zoneId) {
        ImageApi imageApi = ((NovaApi)this.api).getImageApiForZone(zoneId);
        return ((Resource)Iterables.getLast((Iterable)imageApi.list().concat())).getId();
    }

    protected String flavorRefForZone(String zoneId) {
        FlavorApi flavorApi = ((NovaApi)this.api).getFlavorApiForZone(zoneId);
        return ((Flavor)DEFAULT_FLAVOR_ORDERING.min((Iterable)flavorApi.listInDetail().concat())).getId();
    }
}

