/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Module;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApiMetadata;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaExpectTest;

public abstract class BaseNovaComputeServiceContextExpectTest<T>
extends BaseNovaExpectTest<T>
implements Function<ComputeServiceContext, T> {
    protected final HttpRequest listDetail;
    protected final HttpResponse listDetailResponse;
    protected final HttpRequest listFlavorsDetail;
    protected final HttpResponse listFlavorsDetailResponse;
    protected final HttpRequest listServers;
    protected final HttpResponse listServersResponse;
    protected final HttpRequest listFloatingIps;
    protected final HttpResponse listFloatingIpsResponse;

    public BaseNovaComputeServiceContextExpectTest() {
        this.listDetail = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/images/detail")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        this.listDetailResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/image_list_detail.json"))).build();
        this.listFlavorsDetail = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/flavors/detail")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        this.listFlavorsDetailResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/flavor_list_detail.json"))).build();
        this.listServers = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/detail")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        this.listServersResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/server_list_details.json"))).build();
        this.listFloatingIps = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-floating-ips")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        this.listFloatingIpsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/floatingip_list.json"))).build();
    }

    public T createClient(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return (T)this.apply(this.createComputeServiceContext(fn, module, props));
    }

    private ComputeServiceContext createComputeServiceContext(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return (ComputeServiceContext)this.createInjector(fn, module, props).getInstance(ComputeServiceContext.class);
    }

    protected ApiMetadata createApiMetadata() {
        return new NovaApiMetadata();
    }
}

