/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.internal;

import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.internal.KeystoneFixture;
import org.jclouds.rest.internal.BaseRestApiExpectTest;

public class BaseNovaExpectTest<T>
extends BaseRestApiExpectTest<T> {
    protected HttpRequest keystoneAuthWithUsernameAndPassword;
    protected HttpRequest keystoneAuthWithUsernameAndPasswordAndTenantName;
    protected HttpRequest keystoneAuthWithAccessKeyAndSecretKeyAndTenantName;
    protected String authToken;
    protected HttpResponse responseWithKeystoneAccess;
    protected HttpRequest extensionsOfNovaRequest;
    protected HttpResponse extensionsOfNovaResponse;
    protected HttpResponse unmatchedExtensionsOfNovaResponse;
    protected HttpRequest keystoneAuthWithAccessKeyAndSecretKeyAndTenantId;
    protected String identityWithTenantId;

    public BaseNovaExpectTest() {
        this.provider = "openstack-nova";
        this.keystoneAuthWithUsernameAndPassword = KeystoneFixture.INSTANCE.initialAuthWithUsernameAndPassword(this.identity, this.credential);
        this.keystoneAuthWithUsernameAndPasswordAndTenantName = KeystoneFixture.INSTANCE.initialAuthWithUsernameAndPasswordAndTenantName(this.identity, this.credential);
        this.keystoneAuthWithAccessKeyAndSecretKeyAndTenantName = KeystoneFixture.INSTANCE.initialAuthWithAccessKeyAndSecretKeyAndTenantName(this.identity, this.credential);
        this.keystoneAuthWithAccessKeyAndSecretKeyAndTenantId = KeystoneFixture.INSTANCE.initialAuthWithAccessKeyAndSecretKeyAndTenantId(this.identity, this.credential);
        this.authToken = KeystoneFixture.INSTANCE.getAuthToken();
        this.responseWithKeystoneAccess = KeystoneFixture.INSTANCE.responseWithAccess();
        this.identityWithTenantId = KeystoneFixture.INSTANCE.getTenantId() + ":" + this.identity;
        this.identity = KeystoneFixture.INSTANCE.getTenantName() + ":" + this.identity;
        this.extensionsOfNovaRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/extensions").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        this.extensionsOfNovaResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/extension_list_full.json"))).build();
        this.unmatchedExtensionsOfNovaResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/extension_list.json"))).build();
    }

    protected BaseRestApiExpectTest.HttpRequestComparisonType compareHttpRequestAsType(HttpRequest input) {
        return BaseRestApiExpectTest.HttpRequestComparisonType.JSON;
    }

    protected HttpRequest.Builder<?> authenticatedGET() {
        return (HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken});
    }
}

