/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.parse;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import javax.ws.rs.Consumes;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.nova.v2_0.domain.ServerCreated;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseCreatedServerTest")
public class ParseCreatedServerTest
extends BaseItemParserTest<ServerCreated> {
    public String resource() {
        return "/new_server.json";
    }

    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    public ServerCreated expected() {
        return ((ServerCreated.Builder)((ServerCreated.Builder)((ServerCreated.Builder)ServerCreated.builder().id("71752")).name("test-e92")).adminPass("ZWuHcmTMQ7eXoHeM").links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/37936628937291/servers/71752")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/37936628937291/servers/71752"))})).build();
    }

    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    public ServerCreated expectedWithDiskConfig(String diskConfig) {
        return ((ServerCreated.Builder)((ServerCreated.Builder)((ServerCreated.Builder)ServerCreated.builder().id("71752")).name("test-e92")).adminPass("ZWuHcmTMQ7eXoHeM").diskConfig(diskConfig).links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/37936628937291/servers/71752")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/37936628937291/servers/71752"))})).build();
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new NovaParserModule(), new GsonModule()});
    }
}

