/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.parse;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseSetParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.v2_0.domain.Extension;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseExtensionListNormalTest")
public class ParseExtensionListNormalTest
extends BaseSetParserTest<Extension> {
    public String resource() {
        return "/extension_list_normal.json";
    }

    @SelectJson(value={"extensions"})
    @Consumes(value={"application/json"})
    public Set<Extension> expected() {
        return ImmutableSet.of((Object)((Extension.Builder)Extension.builder().alias("os-keypairs").name("Keypairs")).namespace(URI.create("http://docs.openstack.org/ext/keypairs/api/v1.1")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-08-08T00:00:00+00:00")).description("Keypair Support").build(), (Object)((Extension.Builder)Extension.builder().alias("os-volumes").name("Volumes")).namespace(URI.create("http://docs.openstack.org/ext/volumes/api/v1.1")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-03-25T00:00:00+00:00")).description("Volumes support").build(), (Object)((Extension.Builder)Extension.builder().alias("security_groups").name("SecurityGroups")).namespace(URI.create("http://docs.openstack.org/ext/securitygroups/api/v1.1")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-07-21T00:00:00+00:00")).description("Security group support").build(), (Object)((Extension.Builder)Extension.builder().alias("os-floating-ips").name("Floating_ips")).namespace(URI.create("http://docs.openstack.org/ext/floating_ips/api/v1.1")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-06-16T00:00:00+00:00")).description("Floating IPs support").build());
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new NovaParserModule(), new GsonModule()});
    }
}

