/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.parse;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.Consumes;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseServerTest")
public class ParseServerTest
extends BaseItemParserTest<Server> {
    public String resource() {
        return "/server_details.json";
    }

    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    public Server expected() {
        return ((Server.Builder)((Server.Builder)((Server.Builder)Server.builder().id("52415800-8b69-11e0-9b19-734f000004d2")).tenantId("1234").userId("5678").name("sample-f352")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2010-10-10T12:00:00Z")).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2010-08-10T12:00:00Z")).hostId("e4d909c290d0fb1ca068ffaddf22cbd0").accessIPv4("67.23.10.132").accessIPv6("::babe:67.23.10.132").status(Server.Status.BUILD).diskConfig("AUTO").image(Resource.builder().id("52415800-8b69-11e0-9b19-734f6f006e54").name("null").links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("http://servers.api.openstack.org/v1.1/1234/images/52415800-8b69-11e0-9b19-734f6f006e54")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("http://servers.api.openstack.org/1234/images/52415800-8b69-11e0-9b19-734f6f006e54"))}).build()).flavor(Resource.builder().id("52415800-8b69-11e0-9b19-734f216543fd").name("null").links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("http://servers.api.openstack.org/v1.1/1234/flavors/52415800-8b69-11e0-9b19-734f216543fd")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("http://servers.api.openstack.org/1234/flavors/52415800-8b69-11e0-9b19-734f216543fd"))}).build()).metadata((Map)new ImmutableMap.Builder().put((Object)"Server Label", (Object)"Web Head 1").put((Object)"Image Version", (Object)"2.1").build()).addresses((Multimap)ImmutableMultimap.builder().putAll((Object)"public", (Object[])new Address[]{Address.createV4((String)"67.23.10.132"), Address.createV6((String)"::babe:67.23.10.132"), Address.createV4((String)"67.23.10.131"), Address.createV6((String)"::babe:4317:0A83")}).putAll((Object)"private", (Object[])new Address[]{Address.createV4((String)"10.176.42.16"), Address.createV6((String)"::babe:10.176.42.16")}).build()).links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("http://servers.api.openstack.org/v1.1/1234/servers/52415800-8b69-11e0-9b19-734f6f006e54")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("http://servers.api.openstack.org/1234/servers/52415800-8b69-11e0-9b19-734f6f006e54"))})).build();
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new NovaParserModule(), new GsonModule()});
    }
}

