/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.parse;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import javax.ws.rs.Consumes;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerExtendedAttributes;
import org.jclouds.openstack.nova.v2_0.domain.ServerExtendedStatus;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseServerWithAllExtensionsTest")
public class ParseServerWithAllExtensionsTest
extends BaseItemParserTest<Server> {
    public String resource() {
        return "/server_details_devstack.json";
    }

    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    public Server expected() {
        return ((Server.Builder)((Server.Builder)((Server.Builder)Server.builder().id("141b775f-7ac1-45f0-9a95-146260f33a53")).tenantId("7f312675f9b84c97bff8f5054e181419").userId("89c01b67395d4bea945f7f5bfd7f344a").name("test")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-05-04T15:07:48Z")).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-05-04T15:07:36Z")).hostId("eab9a77d1c44b8833e4a3dc6d2d9d50de556e780a319f184d8c82d9b").status(Server.Status.PAUSED).image(Resource.builder().id("8e6f5bc4-a210-45b2-841f-c510eae14300").links(new Link[]{Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("http://172.16.89.149:8774/7f312675f9b84c97bff8f5054e181419/images/8e6f5bc4-a210-45b2-841f-c510eae14300"))}).build()).flavor(Resource.builder().id("1").links(new Link[]{Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("http://172.16.89.149:8774/7f312675f9b84c97bff8f5054e181419/flavors/1"))}).build()).links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("http://172.16.89.149:8774/v2/7f312675f9b84c97bff8f5054e181419/servers/141b775f-7ac1-45f0-9a95-146260f33a53")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("http://172.16.89.149:8774/7f312675f9b84c97bff8f5054e181419/servers/141b775f-7ac1-45f0-9a95-146260f33a53"))})).addresses((Multimap)ImmutableMultimap.of((Object)"private", (Object)Address.createV4((String)"10.0.0.8"))).diskConfig("MANUAL").extendedStatus(ServerExtendedStatus.builder().vmState("paused").powerState(3).build()).extendedAttributes(ServerExtendedAttributes.builder().instanceName("instance-00000014").hostName("ubuntu").build()).build();
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new NovaParserModule(), new GsonModule()});
    }
}

