/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.binders.BindToJsonPayload;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/flavor_extra_specs/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface FlavorExtraSpecsAsyncApi {
    @Named(value="flavor:getmetadata")
    @GET
    @SelectJson(value={"extra_specs"})
    @Path(value="/flavors/{flavor_id}/os-extra_specs")
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    public ListenableFuture<Map<String, String>> getMetadata(@PathParam(value="flavor_id") String var1);

    @Named(value="flavor:updatemetadata")
    @POST
    @Path(value="/flavors/{flavor_id}/os-extra_specs")
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<Boolean> updateMetadata(@PathParam(value="flavor_id") String var1, @PayloadParam(value="extra_specs") Map<String, String> var2);

    @Named(value="flavor:getmetadata")
    @GET
    @Path(value="/flavors/{flavor_id}/os-extra_specs/{key}")
    @Unwrap
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<String> getMetadataKey(@PathParam(value="flavor_id") String var1, @PathParam(value="key") String var2);

    @Named(value="flavor:updatemetadata")
    @PUT
    @Path(value="/flavors/{flavor_id}/os-extra_specs/{key}")
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Payload(value="%7B\"{key}\":\"{value}\"%7D")
    public ListenableFuture<Boolean> updateMetadataEntry(@PathParam(value="flavor_id") String var1, @PathParam(value="key") @PayloadParam(value="key") String var2, @PayloadParam(value="value") String var3);

    @Named(value="flavor:deletemetadata")
    @DELETE
    @Path(value="/flavors/{flavor_id}/os-extra_specs/{key}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> deleteMetadataKey(@PathParam(value="flavor_id") String var1, @PathParam(value="key") String var2);
}

