/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.Host;
import org.jclouds.openstack.nova.v2_0.domain.HostResourceUsage;
import org.jclouds.openstack.nova.v2_0.functions.FieldValueResponseParsers;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/hosts/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/os-hosts")
@Consumes(value={"application/json"})
@Beta
public interface HostAdministrationAsyncApi {
    @Named(value="hostadmin:list")
    @GET
    @SelectJson(value={"hosts"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends Host>> list();

    @Named(value="hostadmin:listresource")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"host"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends HostResourceUsage>> listResourceUsage(@PathParam(value="id") String var1);

    @Named(value="hostadmin:enable")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Payload(value="{\"status\":\"enable\"}")
    @ResponseParser(value=FieldValueResponseParsers.StatusEnabledResponseParser.class)
    public ListenableFuture<Boolean> enable(@PathParam(value="id") String var1);

    @Named(value="hostadmin:disable")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Payload(value="{\"status\":\"disable\"}")
    @ResponseParser(value=FieldValueResponseParsers.StatusDisabledResponseParser.class)
    public ListenableFuture<Boolean> disable(@PathParam(value="id") String var1);

    @Named(value="hostadmin:startmaintenance")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Payload(value="{\"maintenance_mode\":\"enable\"}")
    @ResponseParser(value=FieldValueResponseParsers.MaintenanceModeEnabledResponseParser.class)
    public ListenableFuture<Boolean> startMaintenance(@PathParam(value="id") String var1);

    @Named(value="hostadmin:stopmaintenance")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Payload(value="{\"maintenance_mode\":\"disable\"}")
    @ResponseParser(value=FieldValueResponseParsers.MaintenanceModeDisabledResponseParser.class)
    public ListenableFuture<Boolean> stopMaintenance(@PathParam(value="id") String var1);

    @Named(value="hostadmin:startup")
    @GET
    @Path(value="/{id}/startup")
    @ResponseParser(value=FieldValueResponseParsers.PowerIsStartupResponseParser.class)
    public ListenableFuture<Boolean> startup(@PathParam(value="id") String var1);

    @Named(value="hostadmin:shutdown")
    @GET
    @Path(value="/{id}/shutdown")
    @ResponseParser(value=FieldValueResponseParsers.PowerIsShutdownResponseParser.class)
    public ListenableFuture<Boolean> shutdown(@PathParam(value="id") String var1);

    @Named(value="hostadmin:reboot")
    @GET
    @Path(value="/{id}/reboot")
    @ResponseParser(value=FieldValueResponseParsers.PowerIsRebootResponseParser.class)
    public ListenableFuture<Boolean> reboot(@PathParam(value="id") String var1);
}

