/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.binders.BindSecurityGroupRuleToJsonPayload;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/securitygroups/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Beta
public interface SecurityGroupAsyncApi {
    @Named(value="securitygroup:list")
    @GET
    @SelectJson(value={"security_groups"})
    @Consumes(value={"application/json"})
    @Path(value="/os-security-groups")
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends SecurityGroup>> list();

    @Named(value="securitygroup:get")
    @GET
    @Path(value="/os-security-groups/{id}")
    @SelectJson(value={"security_group"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends SecurityGroup> get(@PathParam(value="id") String var1);

    @Named(value="securitygroup:create")
    @POST
    @Path(value="/os-security-groups")
    @SelectJson(value={"security_group"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Payload(value="%7B\"security_group\":%7B\"name\":\"{name}\",\"description\":\"{description}\"%7D%7D")
    public ListenableFuture<? extends SecurityGroup> createWithDescription(@PayloadParam(value="name") String var1, @PayloadParam(value="description") String var2);

    @Named(value="securitygroup:delete")
    @DELETE
    @Path(value="/os-security-groups/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    public ListenableFuture<Boolean> delete(@PathParam(value="id") String var1);

    @Named(value="securitygroup:create")
    @POST
    @Path(value="/os-security-group-rules")
    @SelectJson(value={"security_group_rule"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindSecurityGroupRuleToJsonPayload.class)
    public ListenableFuture<? extends SecurityGroupRule> createRuleAllowingCidrBlock(@PayloadParam(value="parent_group_id") String var1, Ingress var2, @PayloadParam(value="cidr") String var3);

    @Named(value="securitygroup:create")
    @POST
    @Path(value="/os-security-group-rules")
    @SelectJson(value={"security_group_rule"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindSecurityGroupRuleToJsonPayload.class)
    public ListenableFuture<? extends SecurityGroupRule> createRuleAllowingSecurityGroupId(@PayloadParam(value="parent_group_id") String var1, Ingress var2, @PayloadParam(value="group_id") String var3);

    @Named(value="securitygroup:delete")
    @DELETE
    @Path(value="/os-security-group-rules/{security_group_rule_ID}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes
    public ListenableFuture<Boolean> deleteRule(@PathParam(value="security_group_rule_ID") String var1);
}

