/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.features;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.domain.CreateDomain;
import org.jclouds.rackspace.clouddns.v1.domain.Domain;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.functions.RecordFunctions;
import org.jclouds.rackspace.clouddns.v1.internal.BaseCloudDNSApiLiveTest;
import org.jclouds.rackspace.clouddns.v1.predicates.JobPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="RecordApiLiveTest")
public class RecordApiLiveTest
extends BaseCloudDNSApiLiveTest {
    private static final String JCLOUDS_EXAMPLE = System.getProperty("user.name").replace('.', '-') + "-recordtest-jclouds.org";
    private int domainId;
    private String aRecordId;
    private String srvRecordId;
    private String mxRecordId;

    @Test
    public void testCreateDomain() throws Exception {
        CreateDomain createDomain = CreateDomain.builder().name(JCLOUDS_EXAMPLE).email("jclouds@" + JCLOUDS_EXAMPLE).ttl(Integer.valueOf(60000)).build();
        ImmutableList createDomains = ImmutableList.of((Object)createDomain);
        Domain domain = (Domain)((Set)JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().create((Iterable)createDomains))).iterator().next();
        Assert.assertEquals((String)domain.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)domain.getEmail(), (String)("jclouds@" + JCLOUDS_EXAMPLE));
        Assert.assertTrue((boolean)domain.getRecords().isEmpty());
        this.domainId = domain.getId();
    }

    @Test(dependsOnMethods={"testCreateDomain"})
    public void testCreateRecords() throws Exception {
        Record createMXRecord = Record.builder().type("MX").name(JCLOUDS_EXAMPLE).data("mail." + JCLOUDS_EXAMPLE).comment("MX Record").priority(Integer.valueOf(11235)).build();
        Record createARecord = Record.builder().type("A").name(JCLOUDS_EXAMPLE).data("10.0.0.1").build();
        Record createSRVRecord = Record.builder().type("SRV").name("_sip._tcp." + JCLOUDS_EXAMPLE).ttl(86400).data("1 3443 sip." + JCLOUDS_EXAMPLE).priority(Integer.valueOf(11235)).comment("Updated Protocol to UDP").build();
        ImmutableList createRecords = ImmutableList.of((Object)createMXRecord, (Object)createARecord, (Object)createSRVRecord);
        Set records = (Set)JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).create((Iterable)createRecords));
        Thread.sleep(1000L);
        Date now = new Date();
        RecordDetail mxRecord = null;
        RecordDetail aRecord = null;
        RecordDetail srvRecord = null;
        for (RecordDetail record : records) {
            if (record.getType().equals("MX")) {
                mxRecord = record;
                continue;
            }
            if (record.getType().equals("A")) {
                aRecord = record;
                continue;
            }
            if (!record.getType().equals("SRV")) continue;
            srvRecord = record;
        }
        Assert.assertNotNull((Object)mxRecord.getId());
        Assert.assertEquals((String)mxRecord.getType(), (String)"MX");
        Assert.assertEquals((String)mxRecord.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((int)mxRecord.getPriority(), (int)11235);
        Assert.assertEquals((String)mxRecord.getComment(), (String)"MX Record");
        Assert.assertEquals((int)mxRecord.getTTL(), (int)60000);
        Assert.assertTrue((boolean)mxRecord.getCreated().before(now));
        Assert.assertTrue((boolean)mxRecord.getUpdated().before(now));
        Assert.assertNotNull((Object)aRecord.getId());
        Assert.assertEquals((String)aRecord.getType(), (String)"A");
        Assert.assertEquals((String)aRecord.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)aRecord.getData(), (String)"10.0.0.1");
        Assert.assertNull((Object)aRecord.getPriority());
        Assert.assertEquals((int)aRecord.getTTL(), (int)60000);
        Assert.assertTrue((boolean)aRecord.getCreated().before(now));
        Assert.assertTrue((boolean)aRecord.getUpdated().before(now));
        Assert.assertNotNull((Object)srvRecord.getId());
        Assert.assertEquals((String)srvRecord.getType(), (String)"SRV");
        Assert.assertEquals((String)srvRecord.getName(), (String)("_sip._tcp." + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)srvRecord.getData(), (String)("1 3443 sip." + JCLOUDS_EXAMPLE));
        Assert.assertEquals((int)srvRecord.getPriority(), (int)11235);
        Assert.assertEquals((int)srvRecord.getTTL(), (int)86400);
        Assert.assertTrue((boolean)srvRecord.getCreated().before(now));
        Assert.assertTrue((boolean)srvRecord.getUpdated().before(now));
    }

    @Test(dependsOnMethods={"testCreateRecords"})
    public void testListRecords() throws Exception {
        ImmutableSet records = ((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).list().concat().toSet();
        Assert.assertEquals((int)records.size(), (int)5);
    }

    @Test(dependsOnMethods={"testListRecords"})
    public void testListRecordsByCriteriaMethods() throws Exception {
        ImmutableList records = ((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).listByType("SRV").concat().toList();
        Assert.assertEquals((int)records.size(), (int)1);
        this.srvRecordId = ((RecordDetail)records.get(0)).getId();
        records = ((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).listByTypeAndData("A", "10.0.0.1").concat().toList();
        Assert.assertEquals((int)records.size(), (int)1);
        this.aRecordId = ((RecordDetail)records.get(0)).getId();
        records = ((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).listByNameAndType(JCLOUDS_EXAMPLE, "MX").concat().toList();
        Assert.assertEquals((int)records.size(), (int)1);
        this.mxRecordId = ((RecordDetail)records.get(0)).getId();
    }

    @Test(dependsOnMethods={"testListRecordsByCriteriaMethods"})
    public void testGetRecordByNameAndTypeAndData() throws Exception {
        RecordDetail record = ((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).getByNameAndTypeAndData(JCLOUDS_EXAMPLE, "A", "10.0.0.1");
        Date now = new Date();
        Assert.assertNotNull((Object)record.getId());
        Assert.assertEquals((String)record.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)record.getType(), (String)"A");
        Assert.assertEquals((String)record.getData(), (String)"10.0.0.1");
        Assert.assertEquals((int)record.getTTL(), (int)60000);
        Assert.assertTrue((boolean)record.getCreated().before(now));
        Assert.assertTrue((boolean)record.getUpdated().before(now));
    }

    @Test(dependsOnMethods={"testGetRecordByNameAndTypeAndData"})
    public void testGetRecord() throws Exception {
        RecordDetail record = ((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).get(this.aRecordId);
        Date now = new Date();
        Assert.assertNotNull((Object)record.getId());
        Assert.assertEquals((String)record.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)record.getType(), (String)"A");
        Assert.assertEquals((String)record.getData(), (String)"10.0.0.1");
        Assert.assertEquals((int)record.getTTL(), (int)60000);
        Assert.assertTrue((boolean)record.getCreated().before(now));
        Assert.assertTrue((boolean)record.getUpdated().before(now));
    }

    @Test(dependsOnMethods={"testGetRecord"})
    public void testUpdateRecord() throws Exception {
        Record record = Record.builder().name("_sip._udp." + JCLOUDS_EXAMPLE).ttl(86401).data("1 3444 sip." + JCLOUDS_EXAMPLE).priority(Integer.valueOf(12358)).comment("Updated Protocol to UDP").build();
        JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).update(this.srvRecordId, record));
        RecordDetail srvRecord = ((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).get(this.srvRecordId);
        Date now = new Date();
        Assert.assertNotNull((Object)srvRecord.getId());
        Assert.assertEquals((String)srvRecord.getType(), (String)"SRV");
        Assert.assertEquals((String)srvRecord.getName(), (String)("_sip._udp." + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)srvRecord.getData(), (String)("1 3444 sip." + JCLOUDS_EXAMPLE));
        Assert.assertEquals((int)srvRecord.getPriority(), (int)12358);
        Assert.assertEquals((int)srvRecord.getTTL(), (int)86401);
        Assert.assertEquals((String)srvRecord.getComment(), (String)"Updated Protocol to UDP");
        Assert.assertTrue((boolean)srvRecord.getCreated().before(now));
        Assert.assertTrue((boolean)srvRecord.getUpdated().before(now));
    }

    @Test(dependsOnMethods={"testUpdateRecord"})
    public void testUpdateRecords() throws Exception {
        ImmutableSet recordDetails = ((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).list().concat().toSet();
        Map idsToRecords = RecordFunctions.toRecordMap((Set)recordDetails);
        Map updateRecords = Maps.transformValues((Map)idsToRecords, this.updateTTLAndComment(35813, "New TTL"));
        JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).update(updateRecords));
        RecordDetail record = ((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).get(this.aRecordId);
        Date now = new Date();
        Assert.assertNotNull((Object)record.getId());
        Assert.assertEquals((String)record.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)record.getType(), (String)"A");
        Assert.assertEquals((String)record.getData(), (String)"10.0.0.1");
        Assert.assertEquals((int)record.getTTL(), (int)35813);
        Assert.assertEquals((String)record.getComment(), (String)"New TTL");
        Assert.assertTrue((boolean)record.getCreated().before(now));
        Assert.assertTrue((boolean)record.getUpdated().before(now));
        recordDetails = ((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).list().concat().toSet();
        for (RecordDetail recordDetail : recordDetails) {
            Assert.assertEquals((int)recordDetail.getTTL(), (int)35813);
            Assert.assertEquals((String)recordDetail.getComment(), (String)"New TTL");
        }
    }

    private Function<Record, Record> updateTTLAndComment(final int ttl, final String comment) {
        return new Function<Record, Record>(){

            public Record apply(Record record) {
                return record.toBuilder().ttl(ttl).comment(comment).build();
            }
        };
    }

    @Test(dependsOnMethods={"testUpdateRecords"})
    public void testDeleteRecord() throws Exception {
        JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).delete(this.aRecordId));
        Assert.assertNull((Object)((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).get(this.aRecordId));
    }

    @Test(dependsOnMethods={"testDeleteRecord"})
    public void testDeleteRecords() throws Exception {
        ImmutableList recordIds = ImmutableList.of((Object)this.srvRecordId, (Object)this.mxRecordId);
        JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).delete((Iterable)recordIds));
        Assert.assertNull((Object)((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).get(this.srvRecordId));
        Assert.assertNull((Object)((CloudDNSApi)this.api).getRecordApiForDomain(this.domainId).get(this.mxRecordId));
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        try {
            JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().delete((Iterable)ImmutableList.of((Object)this.domainId), true));
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        super.tearDown();
    }
}

