/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1;

import java.io.Closeable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rackspace.clouddns.v1.config.CloudDNS;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.features.DomainApi;
import org.jclouds.rackspace.clouddns.v1.features.LimitApi;
import org.jclouds.rackspace.clouddns.v1.features.RecordApi;
import org.jclouds.rackspace.clouddns.v1.features.ReverseDNSApi;
import org.jclouds.rackspace.clouddns.v1.functions.ParseJob;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

public interface CloudDNSApi
extends Closeable {
    @Named(value="job:get")
    @Endpoint(value=CloudDNS.class)
    @RequestFilters(value={AuthenticateRequest.class})
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @QueryParams(keys={"showDetails"}, values={"true"})
    @Path(value="/status/{jobId}")
    @Nullable
    public <T> Job<T> getJob(@PathParam(value="jobId") String var1);

    @Delegate
    public LimitApi getLimitApi();

    @Delegate
    public DomainApi getDomainApi();

    @Delegate
    @Path(value="/domains/{domainId}")
    public RecordApi getRecordApiForDomain(@PathParam(value="domainId") int var1);

    @Delegate
    public ReverseDNSApi getReverseDNSApiForService(@PayloadParam(value="serviceName") @PathParam(value="serviceName") String var1);
}

