/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rackspace.clouddns.v1.domain.Domain;
import org.jclouds.rackspace.cloudidentity.v2_0.domain.PaginatedCollection;

public class ParseDomains
implements Function<HttpResponse, PaginatedCollection<Domain>> {
    private final ParseJson<Domains> json;

    @Inject
    ParseDomains(ParseJson<Domains> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public PaginatedCollection<Domain> apply(HttpResponse response) {
        Domains domains = (Domains)((Object)this.json.apply(response));
        return domains;
    }

    private static class Domains
    extends PaginatedCollection<Domain> {
        @ConstructorProperties(value={"domains", "links", "totalEntries"})
        protected Domains(Iterable<Domain> domains, Iterable<Link> links, int totalEntries) {
            super(domains, links, totalEntries);
        }
    }
}

