/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.features.RecordApi;
import org.jclouds.rackspace.cloudidentity.v2_0.domain.PaginatedCollection;
import org.jclouds.rackspace.cloudidentity.v2_0.options.PaginationOptions;

@Beta
public class RecordsToPagedIterable
extends Arg0ToPagedIterable.FromCaller<RecordDetail, RecordsToPagedIterable> {
    private final CloudDNSApi api;

    @Inject
    protected RecordsToPagedIterable(CloudDNSApi api) {
        this.api = (CloudDNSApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<RecordDetail>> markerToNextForArg0(Optional<Object> arg0) {
        int domainId = (Integer)Integer.class.cast(arg0.get());
        return new ListRecordsAtMarker(this.api.getRecordApiForDomain(domainId));
    }

    private static class ListRecordsAtMarker
    implements Function<Object, IterableWithMarker<RecordDetail>> {
        private final RecordApi api;

        @Inject
        protected ListRecordsAtMarker(RecordApi api) {
            this.api = (RecordApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        public PaginatedCollection<RecordDetail> apply(Object input) {
            PaginationOptions paginationOptions = (PaginationOptions)input;
            return this.api.list(paginationOptions);
        }

        public String toString() {
            return "ListRecordsAtMarker";
        }
    }
}

