/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.features;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rackspace.clouddns.v1.binders.CreateReverseDNSToJSON;
import org.jclouds.rackspace.clouddns.v1.binders.UpdateReverseDNSToJSON;
import org.jclouds.rackspace.clouddns.v1.config.CloudDNS;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.functions.ParseJob;
import org.jclouds.rackspace.clouddns.v1.functions.ParseRecord;
import org.jclouds.rackspace.clouddns.v1.functions.ParseRecords;
import org.jclouds.rackspace.clouddns.v1.functions.RecordsToPagedIterable;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;

@Endpoint(value=CloudDNS.class)
@RequestFilters(value={AuthenticateRequest.class})
public interface ReverseDNSApi {
    @Named(value="rdns:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseRecords.class)
    @Transform(value=RecordsToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    @Path(value="/rdns/{serviceName}")
    public PagedIterable<RecordDetail> list(@QueryParam(value="href") URI var1);

    @Named(value="rdns:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseRecord.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/rdns/{serviceName}/{recordId}")
    public RecordDetail get(@QueryParam(value="href") URI var1, @PathParam(value="recordId") String var2);

    @Named(value="rdns:create")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @MapBinder(value=CreateReverseDNSToJSON.class)
    @Path(value="/rdns")
    public Job<Set<RecordDetail>> create(@PayloadParam(value="href") URI var1, @PayloadParam(value="records") Iterable<Record> var2);

    @Named(value="rdns:update")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @MapBinder(value=UpdateReverseDNSToJSON.class)
    @Path(value="/rdns")
    public Job<Void> update(@PayloadParam(value="href") URI var1, @PayloadParam(value="idsToRecords") Map<String, Record> var2);

    @Named(value="rdns:delete")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @ResponseParser(value=ParseJob.class)
    @Path(value="/rdns/{serviceName}")
    @Consumes(value={"*/*"})
    public Job<Void> delete(@QueryParam(value="href") URI var1, @QueryParam(value="ip") String var2);

    @Named(value="rdns:delete")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @ResponseParser(value=ParseJob.class)
    @Path(value="/rdns/{serviceName}")
    @Consumes(value={"*/*"})
    public Job<Void> deleteAll(@QueryParam(value="href") URI var1);
}

