/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.functions.ParseRecord;

public class ParseRecords
implements Function<HttpResponse, PaginatedCollection<RecordDetail>> {
    private final ParseJson<RawRecords> json;

    @Inject
    ParseRecords(ParseJson<RawRecords> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public PaginatedCollection<RecordDetail> apply(HttpResponse response) {
        RawRecords rawRecords = (RawRecords)((Object)this.json.apply(response));
        FluentIterable records = rawRecords.transform(ParseRecord.toRecordDetails);
        return new Records((Iterable<RecordDetail>)records, rawRecords.getLinks(), (Integer)rawRecords.getTotalEntries().get());
    }

    private static class Records
    extends PaginatedCollection<RecordDetail> {
        protected Records(Iterable<RecordDetail> records, Iterable<Link> links, int totalEntries) {
            super(records, links, Integer.valueOf(totalEntries));
        }
    }

    private static class RawRecords
    extends PaginatedCollection<ParseRecord.RawRecord> {
        @ConstructorProperties(value={"records", "links", "totalEntries"})
        protected RawRecords(Iterable<ParseRecord.RawRecord> records, Iterable<Link> links, int totalEntries) {
            super(records, links, Integer.valueOf(totalEntries));
        }
    }
}

