/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ErrorPageApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancerApiExpectTest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ErrorPageApiExpectTest
extends BaseCloudLoadBalancerApiExpectTest<CloudLoadBalancersApi> {
    public String contentExpected = ErrorPageApiExpectTest.getContentExpected();
    public String contentEscaped = ErrorPageApiExpectTest.getContentEscaped();

    public void testGetErrorPage() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/errorpage");
        ErrorPageApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(ErrorPageApiExpectTest.payloadFromStringWithContentType((String)("{\"errorpage\":{\"content\":\"" + this.contentEscaped + "\"}}"), (String)"application/json"))).build())).getErrorPageApiForZoneAndLoadBalancer("DFW", 2000);
        String content = api.get();
        Assert.assertEquals((String)content, (String)this.contentExpected);
    }

    public void testCreateErrorPage() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/errorpage");
        ErrorPageApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)((HttpRequest.Builder)this.authenticatedGET().method("PUT").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).payload(ErrorPageApiExpectTest.payloadFromStringWithContentType((String)("{\"errorpage\":{\"content\":\"" + this.contentEscaped + "\"}}"), (String)"application/json"))).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getErrorPageApiForZoneAndLoadBalancer("DFW", 2000);
        api.create(this.contentEscaped);
    }

    public void testRemoveErrorPage() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/errorpage");
        ErrorPageApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getErrorPageApiForZoneAndLoadBalancer("DFW", 2000);
        Assert.assertTrue((boolean)api.delete());
    }

    public static String getContentExpected() {
        String contentExpected;
        try {
            contentExpected = Strings2.toStringAndClose((InputStream)ErrorPageApiExpectTest.class.getResourceAsStream("/errorpage.html"));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read in /errorpage.html", e);
        }
        return contentExpected;
    }

    public static String getContentEscaped() {
        String contentEscaped = ErrorPageApiExpectTest.getContentExpected().replaceAll("\"", "\\\\\"");
        contentEscaped = contentEscaped.replaceAll("\n", "\\\\n");
        return contentEscaped;
    }
}

