/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.HealthMonitor;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.HealthMonitorApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancerApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class HealthMonitorApiExpectTest
extends BaseCloudLoadBalancerApiExpectTest<CloudLoadBalancersApi> {
    public void testGetHealthMonitor() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/healthmonitor");
        HealthMonitorApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/healthmonitor-get.json"))).build())).getHealthMonitorApiForZoneAndLoadBalancer("DFW", 2000);
        HealthMonitor healthMonitor = api.get();
        Assert.assertEquals((Object)healthMonitor, (Object)HealthMonitorApiExpectTest.getConnectHealthMonitor());
    }

    public void testGetDeletedHealthMonitor() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/healthmonitor");
        HealthMonitorApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/healthmonitor-get-deleted.json"))).build())).getHealthMonitorApiForZoneAndLoadBalancer("DFW", 2000);
        HealthMonitor healthMonitor = api.get();
        Assert.assertNull((Object)healthMonitor);
    }

    public void testCreateHealthMonitor() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/healthmonitor");
        HealthMonitorApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").endpoint(endpoint).payload(this.payloadFromResource("/healthmonitor-create.json"))).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getHealthMonitorApiForZoneAndLoadBalancer("DFW", 2000);
        api.createOrUpdate(HealthMonitorApiExpectTest.getConnectHealthMonitor());
    }

    public void testRemoveHealthMonitor() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/healthmonitor");
        HealthMonitorApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getHealthMonitorApiForZoneAndLoadBalancer("DFW", 2000);
        Assert.assertTrue((boolean)api.delete());
    }

    public void testValidConnectHealthMonitor() {
        Assert.assertTrue((boolean)HealthMonitorApiExpectTest.getConnectHealthMonitor().isValid());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidConnectHealthMonitorWithoutRequirements() {
        HealthMonitor.builder().type(HealthMonitor.Type.CONNECT).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidConnectHealthMonitorWithUnrequired() {
        HealthMonitor.builder().type(HealthMonitor.Type.CONNECT).delay(3599).timeout(30).attemptsBeforeDeactivation(2).path("/foobar").build();
    }

    public void testValidHTTPHealthMonitor() {
        Assert.assertTrue((boolean)HealthMonitorApiExpectTest.getHTTPHealthMonitor().isValid());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidHTTPHealthMonitorWithoutRequirements() {
        HealthMonitor.builder().type(HealthMonitor.Type.HTTP).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidHTTPHealthMonitorWithoutUnrequired() {
        HealthMonitor.builder().type(HealthMonitor.Type.HTTP).delay(3599).path("/foobar").build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidHTTPHealthMonitorWithoutRegex() {
        HealthMonitor.builder().type(HealthMonitor.Type.HTTP).delay(3599).timeout(30).attemptsBeforeDeactivation(2).path("/foobar").build();
    }

    public static HealthMonitor getConnectHealthMonitor() {
        HealthMonitor healthMonitor = HealthMonitor.builder().type(HealthMonitor.Type.CONNECT).delay(3599).timeout(30).attemptsBeforeDeactivation(2).build();
        return healthMonitor;
    }

    public static HealthMonitor getHTTPHealthMonitor() {
        HealthMonitor healthMonitor = HealthMonitor.builder().type(HealthMonitor.Type.HTTP).delay(3599).timeout(30).attemptsBeforeDeactivation(2).path("/foobar").bodyRegex("foo.*bar").build();
        return healthMonitor;
    }
}

