/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.CreateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.UpdateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIPWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancersApiLiveTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.predicates.LoadBalancerPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="LoadBalancerApiLiveTest")
public class LoadBalancerApiLiveTest
extends BaseCloudLoadBalancersApiLiveTest {
    private Set<LoadBalancer> lbs = Sets.newLinkedHashSet();

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        for (LoadBalancer lb : this.lbs) {
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).delete(lb.getId());
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitDeleted((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
        }
        super.tearDown();
    }

    public void testCreateLoadBalancer() throws Exception {
        for (String zone : ((CloudLoadBalancersApi)this.api).getConfiguredZones()) {
            Logger.getAnonymousLogger().info("starting lb in region " + zone);
            LoadBalancer lb = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(zone).create(CreateLoadBalancer.builder().name(this.prefix + "-" + zone).protocol("HTTP").port(Integer.valueOf(80)).virtualIPType(VirtualIP.Type.PUBLIC).node(AddNode.builder().address("192.168.1.1").port(8080).build()).build());
            this.checkLBInRegion(zone, lb, this.prefix + "-" + zone);
            Assert.assertEquals((Object)lb.getStatus(), (Object)LoadBalancer.Status.BUILD);
            this.lbs.add(lb);
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            LoadBalancer newLb = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(zone).get(lb.getId());
            this.checkLBInRegion(zone, newLb, this.prefix + "-" + zone);
            Assert.assertEquals((Object)newLb.getStatus(), (Object)LoadBalancer.Status.ACTIVE);
        }
    }

    @Test(dependsOnMethods={"testCreateLoadBalancer"})
    public void testUpdateLoadBalancer() throws Exception {
        for (LoadBalancer lb : this.lbs) {
            ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).update(lb.getId(), UpdateLoadBalancer.builder().name("foo-" + lb.getRegion()).build());
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            LoadBalancer newLb = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).get(lb.getId());
            this.checkLBInRegion(newLb.getRegion(), newLb, "foo-" + lb.getRegion());
            Assert.assertEquals((Object)newLb.getStatus(), (Object)LoadBalancer.Status.ACTIVE);
        }
    }

    @Test(dependsOnMethods={"testUpdateLoadBalancer"})
    public void testListLoadBalancers() throws Exception {
        for (String zone : ((CloudLoadBalancersApi)this.api).getConfiguredZones()) {
            ImmutableSet response = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(zone).list().concat().toSet();
            Assert.assertNotNull((Object)response);
            Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
            for (LoadBalancer lb : response) {
                if (!this.lbs.contains(lb)) continue;
                assert (lb.getRegion() != null) : lb;
                assert (lb.getName() != null) : lb;
                assert (lb.getId() != -1) : lb;
                assert (lb.getProtocol() != null) : lb;
                assert (lb.getPort() != -1) : lb;
                assert (lb.getStatus() != null) : lb;
                assert (lb.getCreated() != null) : lb;
                assert (lb.getUpdated() != null) : lb;
                assert (lb.getVirtualIPs().size() > 0) : lb;
                assert (lb.getNodes().size() == 0) : lb;
                LoadBalancer getDetails = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(zone).get(lb.getId());
                try {
                    Assert.assertEquals((String)getDetails.getRegion(), (String)lb.getRegion());
                    Assert.assertEquals((String)getDetails.getName(), (String)lb.getName());
                    Assert.assertEquals((int)getDetails.getId(), (int)lb.getId());
                    Assert.assertEquals((String)getDetails.getProtocol(), (String)lb.getProtocol());
                    Assert.assertEquals((Object)getDetails.getPort(), (Object)lb.getPort());
                    Assert.assertEquals((Object)getDetails.getStatus(), (Object)lb.getStatus());
                    Assert.assertEquals((Object)getDetails.getCreated(), (Object)lb.getCreated());
                    Assert.assertEquals((Object)getDetails.getUpdated(), (Object)lb.getUpdated());
                    Assert.assertEquals((Set)getDetails.getVirtualIPs(), (Set)lb.getVirtualIPs());
                    assert (getDetails.getNodes().size() > 0) : lb;
                }
                catch (AssertionError e) {
                    throw new AssertionError((Object)String.format("%s\n%s - %s", ((Throwable)((Object)e)).getMessage(), getDetails, lb));
                }
            }
        }
    }

    @Test(dependsOnMethods={"testListLoadBalancers"})
    public void testLoadBalancerMetadata() throws Exception {
        for (LoadBalancer lb : this.lbs) {
            ImmutableMap metadataMap = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2", (Object)"key3", (Object)"value3");
            Metadata metadata = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).createMetadata(lb.getId(), (Map)metadataMap);
            Assert.assertEquals((Map)metadata, (Map)this.getExpectedMetadata());
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            metadata = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).getMetadata(lb.getId());
            Assert.assertEquals((Map)metadata, (Map)this.getExpectedMetadata());
            Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).updateMetadatum(lb.getId(), metadata.getId("key1"), "key1-updated"));
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            metadata = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).getMetadata(lb.getId());
            Assert.assertEquals((String)((String)metadata.get((Object)"key1")), (String)"key1-updated");
            Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).deleteMetadatum(lb.getId(), metadata.getId("key1")));
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            metadata = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).getMetadata(lb.getId());
            Assert.assertNull((Object)metadata.get((Object)"key1"));
            Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).deleteMetadata(lb.getId(), (Iterable)ImmutableList.of((Object)metadata.getId("key2"), (Object)metadata.getId("key3"))));
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            metadata = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion()).getMetadata(lb.getId());
            Assert.assertEquals((int)metadata.size(), (int)0);
        }
    }

    private void checkLBInRegion(String region, LoadBalancer lb, String name) {
        Assert.assertEquals((String)lb.getRegion(), (String)region);
        Assert.assertEquals((String)lb.getName(), (String)name);
        Assert.assertEquals((String)lb.getProtocol(), (String)"HTTP");
        Assert.assertEquals((Object)lb.getPort(), (Object)new Integer(80));
        Assert.assertEquals((Object)((VirtualIPWithId)Iterables.get((Iterable)lb.getVirtualIPs(), (int)0)).getType(), (Object)VirtualIP.Type.PUBLIC);
    }

    private Metadata getExpectedMetadata() {
        Metadata metadata = new Metadata();
        metadata.put((Object)"key1", (Object)"value1");
        metadata.put((Object)"key2", (Object)"value2");
        metadata.put((Object)"key3", (Object)"value3");
        return metadata;
    }
}

