/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Node;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.UpdateNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.NodeApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancerApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class NodeApiExpectTest
extends BaseCloudLoadBalancerApiExpectTest<CloudLoadBalancersApi> {
    public void testListNodes() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/nodes");
        NodeApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/nodes-list.json"))).build())).getNodeApiForZoneAndLoadBalancer("DFW", 2000);
        ImmutableSet nodes = api.list().concat().toSet();
        Assert.assertEquals((Set)nodes, this.getExpectedNodes());
    }

    public void testGetNodeInLoadBalancer() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/nodes/410");
        NodeApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/node-get.json"))).build())).getNodeApiForZoneAndLoadBalancer("DFW", 2000);
        Node node = api.get(410);
        Assert.assertEquals((Object)node, (Object)this.testNode());
    }

    public void testAddNodesInLoadBalancer() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/nodes");
        NodeApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("POST").payload(this.payloadFromResourceWithContentType("/nodes-add.json", "application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/nodes-list.json"))).build())).getNodeApiForZoneAndLoadBalancer("DFW", 2000);
        AddNode addNode1 = AddNode.builder().address("10.1.1.1").condition(BaseNode.Condition.ENABLED).port(80).weight(Integer.valueOf(3)).build();
        AddNode addNode2 = AddNode.builder().address("10.1.1.2").condition(BaseNode.Condition.ENABLED).type(BaseNode.Type.SECONDARY).port(80).weight(Integer.valueOf(8)).build();
        AddNode addNode3 = AddNode.builder().address("10.1.1.3").condition(BaseNode.Condition.DISABLED).port(80).weight(Integer.valueOf(12)).build();
        ImmutableSortedSet addNodes = ImmutableSortedSet.of((Comparable)addNode1, (Comparable)addNode2, (Comparable)addNode3);
        Set nodes = api.add((Iterable)addNodes);
        Assert.assertEquals((Set)nodes, this.getExpectedNodes());
    }

    public void testUpdateAttributesForNodeInLoadBalancer() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/nodes/410");
        NodeApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").payload(this.payloadFromResource("/node-update.json"))).endpoint(endpoint).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getNodeApiForZoneAndLoadBalancer("DFW", 2000);
        UpdateNode updateNode = UpdateNode.builder().condition(BaseNode.Condition.DISABLED).type(BaseNode.Type.SECONDARY).weight(Integer.valueOf(20)).build();
        api.update(410, updateNode);
    }

    public void testRemoveNodeFromLoadBalancer() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/nodes/410");
        NodeApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").replaceHeader("Accept", new String[]{"*/*"})).endpoint(endpoint).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getNodeApiForZoneAndLoadBalancer("DFW", 2000);
        api.remove(410);
    }

    public void testRemoveNodesFromLoadBalancer() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/nodes?id=410&id=411");
        NodeApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").replaceHeader("Accept", new String[]{"*/*"})).endpoint(endpoint).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getNodeApiForZoneAndLoadBalancer("DFW", 2000);
        ImmutableSortedSet nodeIds = ImmutableSortedSet.of((Comparable)Integer.valueOf(410), (Comparable)Integer.valueOf(411));
        api.remove((Iterable)nodeIds);
    }

    public void testListMetadata() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/nodes/410/metadata");
        NodeApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/metadata-list.json"))).build())).getNodeApiForZoneAndLoadBalancer("DFW", 2000);
        Metadata metadata = api.getMetadata(410);
        Assert.assertEquals((Map)metadata, (Map)this.getExpectedMetadataWithIds());
    }

    public void testCreateMetadata() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/nodes/410/metadata");
        NodeApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("POST").endpoint(endpoint).payload(this.payloadFromResourceWithContentType("/metadata-create.json", "application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/metadata-list.json"))).build())).getNodeApiForZoneAndLoadBalancer("DFW", 2000);
        Metadata metadata = api.createMetadata(410, (Map)this.getExpectedMetadata());
        Assert.assertEquals((Map)metadata, (Map)this.getExpectedMetadataWithIds());
    }

    public void testRemoveSingleMetadata() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/nodes/410/metadata/23");
        NodeApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getNodeApiForZoneAndLoadBalancer("DFW", 2000);
        Assert.assertTrue((boolean)api.deleteMetadatum(410, 23));
    }

    public void testRemoveManyMetadata() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/nodes/410/metadata?id=23&id=24");
        NodeApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getNodeApiForZoneAndLoadBalancer("DFW", 2000);
        Assert.assertTrue((boolean)api.deleteMetadata(410, (Iterable)ImmutableList.of((Object)23, (Object)24)));
    }

    private Metadata getExpectedMetadata() {
        Metadata metadata = new Metadata();
        metadata.put((Object)"color", (Object)"red");
        metadata.put((Object)"label", (Object)"web-load-balancer");
        metadata.put((Object)"os", (Object)"ubuntu");
        return metadata;
    }

    private Metadata getExpectedMetadataWithIds() {
        Metadata metadata = this.getExpectedMetadata();
        metadata.putId("color", 1);
        metadata.putId("label", 2);
        metadata.putId("os", 3);
        return metadata;
    }

    private Set<Node> getExpectedNodes() {
        Node node1 = Node.builder().id(410).address("10.1.1.1").port(80).condition(BaseNode.Condition.ENABLED).type(BaseNode.Type.PRIMARY).status(Node.Status.ONLINE).weight(Integer.valueOf(3)).build();
        Node node2 = Node.builder().id(411).address("10.1.1.2").port(80).condition(BaseNode.Condition.ENABLED).type(BaseNode.Type.SECONDARY).status(Node.Status.ONLINE).weight(Integer.valueOf(8)).build();
        Node node3 = Node.builder().id(412).address("10.1.1.3").port(80).condition(BaseNode.Condition.DISABLED).type(BaseNode.Type.PRIMARY).status(Node.Status.ONLINE).weight(Integer.valueOf(12)).build();
        return ImmutableSet.of((Object)node1, (Object)node2, (Object)node3);
    }

    private Node testNode() {
        return Node.builder().id(410).address("10.1.1.1").port(80).condition(BaseNode.Condition.ENABLED).type(BaseNode.Type.PRIMARY).status(Node.Status.ONLINE).weight(Integer.valueOf(12)).build();
    }
}

