/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.CreateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Node;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.UpdateNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancersApiLiveTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.predicates.LoadBalancerPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="NodeClientLiveTest")
public class NodeApiLiveTest
extends BaseCloudLoadBalancersApiLiveTest {
    private Map<LoadBalancer, Set<Node>> nodes = Maps.newHashMap();

    public void testCreateLoadBalancers() {
        Assert.assertTrue((((CloudLoadBalancersApi)this.api).getConfiguredZones().size() > 0 ? 1 : 0) != 0, (String)"Need to have some zones!");
        Logger.getAnonymousLogger().info("running against zones " + ((CloudLoadBalancersApi)this.api).getConfiguredZones());
        for (String zone : ((CloudLoadBalancersApi)this.api).getConfiguredZones()) {
            Logger.getAnonymousLogger().info("starting lb in zone " + zone);
            LoadBalancer lb = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(zone).create(CreateLoadBalancer.builder().name(this.prefix + "-" + zone).protocol("HTTP").port(Integer.valueOf(80)).virtualIPType(VirtualIP.Type.PUBLIC).node(AddNode.builder().address("192.168.1.1").port(8080).build()).build());
            this.nodes.put(lb, new HashSet());
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
        }
    }

    @Test(dependsOnMethods={"testCreateLoadBalancers"})
    public void testAddNodes() throws Exception {
        for (Map.Entry<LoadBalancer, Set<Node>> entry : this.nodes.entrySet()) {
            LoadBalancer lb = entry.getKey();
            Set<Node> nodeSet = entry.getValue();
            String region = lb.getRegion();
            Logger.getAnonymousLogger().info("starting node on loadbalancer " + lb.getId() + " in region " + region);
            Set newNodes = ((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(region, lb.getId()).add((Iterable)ImmutableSet.of((Object)AddNode.builder().address("192.168.1.2").port(8080).build()));
            for (Node n : newNodes) {
                Assert.assertEquals((Object)n.getStatus(), (Object)Node.Status.ONLINE);
                nodeSet.add(n);
                Assert.assertEquals((Object)((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(region, lb.getId()).get(n.getId()).getStatus(), (Object)Node.Status.ONLINE);
            }
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
        }
    }

    @Test(dependsOnMethods={"testAddNodes"})
    public void testModifyNode() throws Exception {
        for (Map.Entry<LoadBalancer, Set<Node>> entry : this.nodes.entrySet()) {
            for (Node n : entry.getValue()) {
                String region = entry.getKey().getRegion();
                ((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(region, entry.getKey().getId()).update(n.getId(), UpdateNode.builder().weight(Integer.valueOf(23)).build());
                Assert.assertEquals((Object)((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(region, entry.getKey().getId()).get(n.getId()).getStatus(), (Object)Node.Status.ONLINE);
                Node newNode = ((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(region, entry.getKey().getId()).get(n.getId());
                Assert.assertEquals((Object)newNode.getStatus(), (Object)Node.Status.ONLINE);
                Assert.assertEquals((Object)newNode.getWeight(), (Object)23);
            }
        }
    }

    @Test(dependsOnMethods={"testModifyNode"})
    public void testListNodes() throws Exception {
        for (LoadBalancer lb : this.nodes.keySet()) {
            ImmutableSet response = ((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(lb.getRegion(), lb.getId()).list().concat().toSet();
            assert (null != response);
            Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
            for (Node n : response) {
                assert (n.getId() != -1) : n;
                assert (n.getCondition() != null) : n;
                assert (n.getAddress() != null) : n;
                assert (n.getPort() != -1) : n;
                assert (n.getStatus() != null) : n;
                assert (!Arrays.asList(LoadBalancer.WEIGHTED_ALGORITHMS).contains(lb.getAlgorithm()) || n.getWeight() != null) : n;
                Node getDetails = ((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(lb.getRegion(), lb.getId()).get(n.getId());
                try {
                    Assert.assertEquals((int)getDetails.getId(), (int)n.getId());
                    Assert.assertEquals((Object)getDetails.getCondition(), (Object)n.getCondition());
                    Assert.assertEquals((String)getDetails.getAddress(), (String)n.getAddress());
                    Assert.assertEquals((int)getDetails.getPort(), (int)n.getPort());
                    Assert.assertEquals((Object)getDetails.getStatus(), (Object)n.getStatus());
                    if (!Arrays.asList(LoadBalancer.WEIGHTED_ALGORITHMS).contains(lb.getAlgorithm())) continue;
                    Assert.assertEquals((Object)getDetails.getWeight(), (Object)n.getWeight());
                }
                catch (AssertionError e) {
                    throw new AssertionError((Object)String.format("%s\n%s - %s", ((Throwable)((Object)e)).getMessage(), getDetails, n));
                }
            }
        }
    }

    @Test(dependsOnMethods={"testListNodes"})
    public void testNodeMetadata() throws Exception {
        for (Map.Entry<LoadBalancer, Set<Node>> entry : this.nodes.entrySet()) {
            LoadBalancer lb = entry.getKey();
            Node node = entry.getValue().iterator().next();
            ImmutableMap metadataMap = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2", (Object)"key3", (Object)"value3");
            Metadata metadata = ((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(lb.getRegion(), lb.getId()).createMetadata(node.getId(), (Map)metadataMap);
            Assert.assertEquals((Map)metadata, (Map)this.getExpectedMetadata());
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            metadata = ((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(lb.getRegion(), lb.getId()).getMetadata(node.getId());
            Assert.assertEquals((Map)metadata, (Map)this.getExpectedMetadata());
            Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(lb.getRegion(), lb.getId()).updateMetadatum(node.getId(), metadata.getId("key1"), "key1-updated"));
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            metadata = ((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(lb.getRegion(), lb.getId()).getMetadata(node.getId());
            Assert.assertEquals((String)((String)metadata.get((Object)"key1")), (String)"key1-updated");
            Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(lb.getRegion(), lb.getId()).deleteMetadatum(node.getId(), metadata.getId("key1")));
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            metadata = ((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(lb.getRegion(), lb.getId()).getMetadata(node.getId());
            Assert.assertNull((Object)metadata.get((Object)"key1"));
            Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(lb.getRegion(), lb.getId()).deleteMetadata(node.getId(), (Iterable)ImmutableList.of((Object)metadata.getId("key2"), (Object)metadata.getId("key3"))));
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
            metadata = ((CloudLoadBalancersApi)this.api).getNodeApiForZoneAndLoadBalancer(lb.getRegion(), lb.getId()).getMetadata(node.getId());
            Assert.assertEquals((int)metadata.size(), (int)0);
        }
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        for (Map.Entry<LoadBalancer, Set<Node>> entry : this.nodes.entrySet()) {
            LoadBalancer lb = entry.getKey();
            LoadBalancerApi lbClient = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion());
            if (lbClient.get(lb.getId()).getStatus() != LoadBalancer.Status.DELETED) {
                Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
                lbClient.delete(lb.getId());
            }
            Assert.assertTrue((boolean)LoadBalancerPredicates.awaitDeleted((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(lb.getRegion())).apply((Object)lb));
        }
        super.tearDown();
    }

    private Metadata getExpectedMetadata() {
        Metadata metadata = new Metadata();
        metadata.put((Object)"key1", (Object)"value1");
        metadata.put((Object)"key2", (Object)"value2");
        metadata.put((Object)"key3", (Object)"value3");
        return metadata;
    }
}

