/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccountUsage;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.HistoricalUsage;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancerStats;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ReportApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.DateParser;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancerApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ReportApiExpectTest
extends BaseCloudLoadBalancerApiExpectTest<CloudLoadBalancersApi> {
    public void testListBillableLoadBalancers() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        Date aWeekAgo = calendar.getTime();
        Date today = new Date();
        String query = "?startTime=" + new DateParser().apply((Object)aWeekAgo) + "&endTime=" + new DateParser().apply((Object)today);
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/billable" + query);
        ReportApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/report-billable-list.json"))).build())).getReportApiForZone("DFW");
        FluentIterable loadBalancers = api.listBillableLoadBalancers(aWeekAgo, today).concat();
        Assert.assertEquals((int)Iterables.size((Iterable)loadBalancers), (int)2);
    }

    public void testGetHistoricalUsage() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        Date aWeekAgo = calendar.getTime();
        Date today = new Date();
        String query = "?startTime=" + new DateParser().apply((Object)aWeekAgo) + "&endTime=" + new DateParser().apply((Object)today);
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/usage" + query);
        ReportApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/report-historical-get.json"))).build())).getReportApiForZone("DFW");
        HistoricalUsage historicalUsage = api.getHistoricalUsage(aWeekAgo, today);
        Assert.assertEquals((int)historicalUsage.getAccountId(), (int)717071);
        Assert.assertEquals((int)((AccountUsage)Iterables.get((Iterable)historicalUsage.getAccountUsage(), (int)0)).getNumLoadBalancers(), (int)2);
        Assert.assertEquals((int)Iterables.size((Iterable)historicalUsage.getLoadBalancerInfo()), (int)2);
    }

    public void testListLoadBalancerUsage() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        Date aWeekAgo = calendar.getTime();
        Date today = new Date();
        String query = "?startTime=" + new DateParser().apply((Object)aWeekAgo) + "&endTime=" + new DateParser().apply((Object)today);
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/usage" + query);
        ReportApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/report-loadbalancerusage-list.json"))).build())).getReportApiForZone("DFW");
        FluentIterable loadBalancerUsages = api.listLoadBalancerUsage(2000, aWeekAgo, today).concat();
        Assert.assertEquals((int)Iterables.size((Iterable)loadBalancerUsages), (int)25);
    }

    public void testListCurrentLoadBalancerUsage() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/usage/current");
        ReportApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/report-loadbalancerusage-list.json"))).build())).getReportApiForZone("DFW");
        FluentIterable loadBalancerUsages = api.listCurrentLoadBalancerUsage(2000).concat();
        Assert.assertEquals((int)Iterables.size((Iterable)loadBalancerUsages), (int)25);
    }

    public void testGetLoadBalancerStats() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/stats");
        ReportApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/report-loadbalancerstats-get.json"))).build())).getReportApiForZone("DFW");
        LoadBalancerStats loadBalancerStats = api.getLoadBalancerStats(2000);
        Assert.assertEquals((int)loadBalancerStats.getConnectTimeOut(), (int)2);
        Assert.assertEquals((int)loadBalancerStats.getConnectError(), (int)0);
        Assert.assertEquals((int)loadBalancerStats.getConnectFailure(), (int)0);
        Assert.assertEquals((int)loadBalancerStats.getDataTimedOut(), (int)10);
        Assert.assertEquals((int)loadBalancerStats.getKeepAliveTimedOut(), (int)0);
        Assert.assertEquals((int)loadBalancerStats.getMaxConn(), (int)22);
    }

    public void testListProtocols() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/protocols");
        ReportApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/report-protocols-list.json"))).build())).getReportApiForZone("DFW");
        Iterable protocols = api.listProtocols();
        Assert.assertEquals((int)Iterables.size((Iterable)protocols), (int)20);
    }

    public void testListAlgorithms() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/algorithms");
        ReportApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/report-algorithms-list.json"))).build())).getReportApiForZone("DFW");
        Iterable algorithms = api.listAlgorithms();
        Assert.assertEquals((int)Iterables.size((Iterable)algorithms), (int)5);
    }
}

