/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Calendar;
import java.util.Date;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.CreateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.HistoricalUsage;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancerStats;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancersApiLiveTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.predicates.LoadBalancerPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ReportApiLiveTest")
public class ReportApiLiveTest
extends BaseCloudLoadBalancersApiLiveTest {
    private LoadBalancer lb;
    private String zone;

    public void testCreateLoadBalancer() {
        AddNode addNode = AddNode.builder().address("192.168.1.1").port(8080).build();
        CreateLoadBalancer createLB = CreateLoadBalancer.builder().name(this.prefix + "-jclouds").protocol("HTTP").port(Integer.valueOf(80)).virtualIPType(VirtualIP.Type.PUBLIC).node(addNode).build();
        this.zone = (String)Iterables.getFirst((Iterable)((CloudLoadBalancersApi)this.api).getConfiguredZones(), null);
        this.lb = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone).create(createLB);
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
    }

    @Test(dependsOnMethods={"testCreateLoadBalancer"})
    public void testReports() throws Exception {
        block2: {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            Date yesterday = calendar.getTime();
            Date today = new Date();
            FluentIterable loadBalancers = ((CloudLoadBalancersApi)this.api).getReportApiForZone(this.zone).listBillableLoadBalancers(yesterday, today).concat();
            Assert.assertNotNull((Object)loadBalancers);
            HistoricalUsage historicalUsage = ((CloudLoadBalancersApi)this.api).getReportApiForZone(this.zone).getHistoricalUsage(yesterday, today);
            Assert.assertNotEquals((Object)historicalUsage.getAccountId(), (Object)0);
            FluentIterable loadBalancerUsages = ((CloudLoadBalancersApi)this.api).getReportApiForZone(this.zone).listLoadBalancerUsage(this.lb.getId(), yesterday, today).concat();
            Assert.assertNotNull((Object)loadBalancerUsages);
            loadBalancerUsages = ((CloudLoadBalancersApi)this.api).getReportApiForZone(this.zone).listCurrentLoadBalancerUsage(this.lb.getId()).concat();
            Assert.assertNotNull((Object)loadBalancerUsages);
            try {
                LoadBalancerStats loadBalancerStats = ((CloudLoadBalancersApi)this.api).getReportApiForZone(this.zone).getLoadBalancerStats(this.lb.getId());
                Assert.assertNotNull((Object)loadBalancerStats);
            }
            catch (HttpResponseException e) {
                if (e.getResponse().getStatusCode() == 500) break block2;
                throw e;
            }
        }
        Iterable protocols = ((CloudLoadBalancersApi)this.api).getReportApiForZone(this.zone).listProtocols();
        Assert.assertTrue((!Iterables.isEmpty((Iterable)protocols) ? 1 : 0) != 0);
        Iterable algorithms = ((CloudLoadBalancersApi)this.api).getReportApiForZone(this.zone).listAlgorithms();
        Assert.assertTrue((!Iterables.isEmpty((Iterable)algorithms) ? 1 : 0) != 0);
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone).delete(this.lb.getId());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitDeleted((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        super.tearDown();
    }
}

