/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccessRule;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccessRuleWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.ConnectionThrottle;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.HealthMonitor;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Node;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SSLTermination;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SessionPersistence;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SourceAddresses;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIPWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ConvertLB;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseLoadBalancer;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="UnwrapLoadBalancerTest")
public class ParseLoadBalancerTest
extends BaseItemParserTest<LoadBalancer> {
    public String resource() {
        return "/loadbalancer-get.json";
    }

    public LoadBalancer expected() {
        Metadata metadata = new Metadata();
        metadata.put((Object)"color", (Object)"red");
        metadata.putId("color", 1);
        metadata.put((Object)"label", (Object)"web-load-balancer");
        metadata.putId("label", 2);
        return LoadBalancer.builder().region("DFW").id(2000).name("sample-loadbalancer").protocol("HTTP").port(Integer.valueOf(80)).algorithm(BaseLoadBalancer.Algorithm.RANDOM).status(LoadBalancer.Status.ACTIVE).connectionLogging(Boolean.valueOf(true)).contentCaching(true).nodeCount(2).halfClosed(Boolean.valueOf(false)).healthMonitor(HealthMonitor.builder().type(HealthMonitor.Type.CONNECT).delay(10).timeout(5).attemptsBeforeDeactivation(2).build()).sslTermination(SSLTermination.builder().enabled(true).secureTrafficOnly(false).securePort(443).build()).sourceAddresses(SourceAddresses.builder().ipv6Public("2001:4800:7901::5/64").ipv4Public("174.143.139.137").ipv4Servicenet("10.183.250.137").build()).connectionThrottle(ConnectionThrottle.builder().maxConnections(100).minConnections(10).maxConnectionRate(50).rateInterval(60).build()).accessRules((Iterable)ImmutableSet.of((Object)new AccessRuleWithId(22215, "1.2.3.4/32", AccessRule.Type.DENY), (Object)new AccessRuleWithId(22217, "12.0.0.0/8", AccessRule.Type.ALLOW))).virtualIPs((Iterable)ImmutableSet.of((Object)new VirtualIPWithId(VirtualIP.Type.PUBLIC, VirtualIP.IPVersion.IPV4, 1000, "206.10.10.210"), (Object)new VirtualIPWithId(VirtualIP.Type.PUBLIC, VirtualIP.IPVersion.IPV6, 1001, "2001:4800:7901:0000:9a32:3c2a:0000:0001"))).nodes((Iterable)ImmutableSet.of((Object)Node.builder().id(1041).address("10.1.1.1").port(80).condition(BaseNode.Condition.ENABLED).status(Node.Status.ONLINE).build(), (Object)Node.builder().id(1411).address("10.1.1.2").port(80).condition(BaseNode.Condition.ENABLED).status(Node.Status.ONLINE).build())).sessionPersistenceType(SessionPersistence.HTTP_COOKIE).clusterName("c1.dfw1").created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2010-11-30T03:23:42Z")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2010-11-30T03:23:44Z")).metadata(metadata).uri(URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000")).build();
    }

    protected Injector injector() {
        return super.injector().createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.install(new FactoryModuleBuilder().build(ConvertLB.Factory.class));
            }
        }});
    }

    protected Function<HttpResponse, LoadBalancer> parser(Injector i) {
        return ((ParseLoadBalancer)i.getInstance(ParseLoadBalancer.class)).setEndpointAndRegion(URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000"));
    }
}

