/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ConvertLB;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseLoadBalancer;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="UnwrapLoadBalancerWhenDeletedTest")
public class ParseLoadBalancerWhenDeletedTest
extends BaseItemParserTest<LoadBalancer> {
    public String resource() {
        return "/loadbalancer-get-deleted.json";
    }

    public LoadBalancer expected() {
        return LoadBalancer.builder().region("LON").id(4865).name("adriancole-LON").status(LoadBalancer.Status.DELETED).nodeCount(0).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-12-05T18:03:23Z")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-12-05T18:04:04Z")).uri(URI.create("https://lon.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/4865")).build();
    }

    protected Injector injector() {
        return super.injector().createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.install(new FactoryModuleBuilder().build(ConvertLB.Factory.class));
            }
        }});
    }

    protected Function<HttpResponse, LoadBalancer> parser(Injector i) {
        return ((ParseLoadBalancer)i.getInstance(ParseLoadBalancer.class)).setEndpointAndRegion(URI.create("https://lon.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/4865"));
    }
}

