/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.Set;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.BaseIterableWithMarkerParserTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIPWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ConvertLB;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseLoadBalancers;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseLoadBalancersTest
extends BaseIterableWithMarkerParserTest<LoadBalancer> {
    public Set<LoadBalancer> data() {
        return ImmutableSet.of((Object)LoadBalancer.builder().region("DFW").name("lb-site1").id(71).protocol("HTTP").port(Integer.valueOf(80)).algorithm(BaseLoadBalancer.Algorithm.RANDOM).status(LoadBalancer.Status.ACTIVE).nodeCount(1).virtualIPs((Iterable)ImmutableSet.of((Object)new VirtualIPWithId(VirtualIP.Type.PUBLIC, VirtualIP.IPVersion.IPV4, 403, "206.55.130.1"))).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2010-11-30T03:23:42Z")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2010-11-30T03:23:44Z")).uri(URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/71")).build(), (Object)LoadBalancer.builder().region("DFW").name("lb-site2").id(166).protocol("HTTP").port(Integer.valueOf(80)).algorithm(BaseLoadBalancer.Algorithm.RANDOM).status(LoadBalancer.Status.ACTIVE).nodeCount(1).virtualIPs((Iterable)ImmutableSet.of((Object)new VirtualIPWithId(VirtualIP.Type.PUBLIC, VirtualIP.IPVersion.IPV4, 401, "206.55.130.2"))).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2010-11-30T03:23:42Z")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2010-11-30T03:23:44Z")).uri(URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/166")).build());
    }

    public String resource() {
        return "/loadbalancers-list.json";
    }

    public IterableWithMarker<LoadBalancer> expected() {
        return IterableWithMarkers.from(this.data());
    }

    protected Injector injector() {
        return super.injector().createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.install(new FactoryModuleBuilder().build(ConvertLB.Factory.class));
            }
        }});
    }

    protected Function<HttpResponse, IterableWithMarker<LoadBalancer>> parser(Injector i) {
        return ((ParseLoadBalancers)i.getInstance(ParseLoadBalancers.class)).setEndpointAndRegion(URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers"));
    }
}

