/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1;

import com.google.inject.Provides;
import java.io.Closeable;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Zone;
import org.jclouds.location.functions.ZoneToEndpoint;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.AccessRuleApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ConnectionApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ContentCachingApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ErrorPageApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.HealthMonitorApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.NodeApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ReportApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.SSLTerminationApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.SessionPersistenceApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.VirtualIPApi;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.EndpointParam;

public interface CloudLoadBalancersApi
extends Closeable {
    @Provides
    @Zone
    public Set<String> getConfiguredZones();

    @Delegate
    public LoadBalancerApi getLoadBalancerApiForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public NodeApi getNodeApiForZoneAndLoadBalancer(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public AccessRuleApi getAccessRuleApiForZoneAndLoadBalancer(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public VirtualIPApi getVirtualIPApiForZoneAndLoadBalancer(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public ConnectionApi getConnectionApiForZoneAndLoadBalancer(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public HealthMonitorApi getHealthMonitorApiForZoneAndLoadBalancer(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public SessionPersistenceApi getSessionPersistenceApiForZoneAndLoadBalancer(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public ContentCachingApi getContentCachingApiForZoneAndLoadBalancer(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public SSLTerminationApi getSSLTerminationApiForZoneAndLoadBalancer(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public ErrorPageApi getErrorPageApiForZoneAndLoadBalancer(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1, @PathParam(value="lbId") int var2);

    @Delegate
    public ReportApi getReportApiForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);
}

