/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;

public final class LoadBalancerUsage {
    private final int id;
    private final float averageNumConnections;
    private final float averageNumConnectionsSsl;
    private final int incomingTransferInBytes;
    private final int outgoingTransferInBytes;
    private final int incomingTransferSslInBytes;
    private final int outgoingTransferSslInBytes;
    private final int numVIPs;
    private final int numPolls;
    private final Date startTime;
    private final Date endTime;
    private final VirtualIP.Type vipType;
    private final String sslMode;
    private final Optional<String> eventType;

    @ConstructorProperties(value={"id", "averageNumConnections", "averageNumConnectionsSsl", "incomingTransfer", "outgoingTransfer", "incomingTransferSsl", "outgoingTransferSsl", "numVips", "numPolls", "startTime", "endTime", "vipType", "sslMode", "eventType"})
    protected LoadBalancerUsage(int id, float averageNumConnections, float averageNumConnectionsSsl, int incomingTransferInBytes, int outgoingTransferInBytes, int incomingTransferSslInBytes, int outgoingTransferSslInBytes, int numVIPs, int numPolls, Date startTime, Date endTime, VirtualIP.Type vipType, String sslMode, String eventType) {
        this.id = id;
        this.averageNumConnections = averageNumConnections;
        this.averageNumConnectionsSsl = averageNumConnectionsSsl;
        this.incomingTransferInBytes = incomingTransferInBytes;
        this.outgoingTransferInBytes = outgoingTransferInBytes;
        this.incomingTransferSslInBytes = incomingTransferSslInBytes;
        this.outgoingTransferSslInBytes = outgoingTransferSslInBytes;
        this.numVIPs = numVIPs;
        this.numPolls = numPolls;
        this.startTime = (Date)Preconditions.checkNotNull((Object)startTime, (Object)"startTime");
        this.endTime = (Date)Preconditions.checkNotNull((Object)endTime, (Object)"endTime");
        this.vipType = (VirtualIP.Type)((Object)Preconditions.checkNotNull((Object)((Object)vipType), (Object)"vipType"));
        this.sslMode = (String)Preconditions.checkNotNull((Object)sslMode, (Object)"sslMode");
        this.eventType = Optional.fromNullable((Object)eventType);
    }

    public int getId() {
        return this.id;
    }

    public float getAverageNumConnections() {
        return this.averageNumConnections;
    }

    public float getAverageNumConnectionsSsl() {
        return this.averageNumConnectionsSsl;
    }

    public int getIncomingTransferInBytes() {
        return this.incomingTransferInBytes;
    }

    public int getOutgoingTransferInBytes() {
        return this.outgoingTransferInBytes;
    }

    public int getIncomingTransferSslInBytes() {
        return this.incomingTransferSslInBytes;
    }

    public int getOutgoingTransferSslInBytes() {
        return this.outgoingTransferSslInBytes;
    }

    public int getNumVIPs() {
        return this.numVIPs;
    }

    public int getNumPolls() {
        return this.numPolls;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public VirtualIP.Type getVIPType() {
        return this.vipType;
    }

    public String getSSLMode() {
        return this.sslMode;
    }

    public Optional<String> getEventType() {
        return this.eventType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancerUsage that = (LoadBalancerUsage)LoadBalancerUsage.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("averageNumConnections", this.averageNumConnections).add("averageNumConnectionsSsl", this.averageNumConnectionsSsl).add("incomingTransferInBytes", this.incomingTransferInBytes).add("outgoingTransferInBytes", this.outgoingTransferInBytes).add("incomingTransferSslInBytes", this.incomingTransferSslInBytes).add("outgoingTransferSslInBytes", this.outgoingTransferSslInBytes).add("numVIPs", this.numVIPs).add("numPolls", this.numPolls).add("startTime", (Object)this.startTime).add("endTime", (Object)this.endTime).add("vipType", (Object)this.vipType).add("sslMode", (Object)this.sslMode).add("eventType", this.eventType.orNull()).toString();
    }
}

