/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseNestedBoolean;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={AuthenticateRequest.class})
public interface ContentCachingApi {
    @Named(value="contentcaching:state")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseNestedBoolean.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/contentcaching")
    public boolean isContentCaching();

    @Named(value="contentcaching:state")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Payload(value="{\"contentCaching\":{\"enabled\":true}}")
    @Path(value="/contentcaching")
    public void enable();

    @Named(value="contentcaching:state")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Payload(value="{\"contentCaching\":{\"enabled\":false}}")
    @Path(value="/contentcaching")
    public void disable();
}

