/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import java.util.Date;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.HistoricalUsage;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancerStats;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancerUsage;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Protocol;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.DateParser;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseAlgorithms;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseLoadBalancerUsages;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseLoadBalancers;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@RequestFilters(value={AuthenticateRequest.class})
public interface ReportApi {
    @Named(value="report:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseLoadBalancers.class)
    @Transform(value=ParseLoadBalancers.ToPagedIterable.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/billable")
    public PagedIterable<LoadBalancer> listBillableLoadBalancers(@ParamParser(value=DateParser.class) @QueryParam(value="startTime") Date var1, @ParamParser(value=DateParser.class) @QueryParam(value="endTime") Date var2);

    @Named(value="report:list")
    @GET
    @ResponseParser(value=ParseLoadBalancers.class)
    @Consumes(value={"application/json"})
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/loadbalancers/billable")
    public IterableWithMarker<LoadBalancer> listBillableLoadBalancers(PaginationOptions var1);

    @Named(value="report:list")
    @GET
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/usage")
    public HistoricalUsage getHistoricalUsage(@ParamParser(value=DateParser.class) @QueryParam(value="startTime") Date var1, @ParamParser(value=DateParser.class) @QueryParam(value="endTime") Date var2);

    @Named(value="report:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseLoadBalancerUsages.class)
    @Transform(value=ParseLoadBalancerUsages.ToPagedIterable.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}/usage")
    public PagedIterable<LoadBalancerUsage> listLoadBalancerUsage(@PathParam(value="id") int var1, @ParamParser(value=DateParser.class) @QueryParam(value="startTime") Date var2, @ParamParser(value=DateParser.class) @QueryParam(value="endTime") Date var3);

    @Named(value="report:list")
    @GET
    @ResponseParser(value=ParseLoadBalancerUsages.class)
    @Consumes(value={"application/json"})
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}/usage")
    public IterableWithMarker<LoadBalancerUsage> listLoadBalancerUsage(PaginationOptions var1);

    @Named(value="report:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseLoadBalancerUsages.class)
    @Transform(value=ParseLoadBalancerUsages.ToPagedIterable.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}/usage/current")
    public PagedIterable<LoadBalancerUsage> listCurrentLoadBalancerUsage(@PathParam(value="id") int var1);

    @Named(value="report:list")
    @GET
    @ResponseParser(value=ParseLoadBalancerUsages.class)
    @Consumes(value={"application/json"})
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}/usage/current")
    public IterableWithMarker<LoadBalancerUsage> listCurrentLoadBalancerUsage(PaginationOptions var1);

    @Named(value="report:list")
    @GET
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}/stats")
    public LoadBalancerStats getLoadBalancerStats(@PathParam(value="id") int var1);

    @Named(value="report:list")
    @GET
    @Consumes(value={"application/json"})
    @SelectJson(value={"protocols"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/protocols")
    public Iterable<Protocol> listProtocols();

    @Named(value="report:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseAlgorithms.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/algorithms")
    public Iterable<String> listAlgorithms();
}

