/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Node;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseMetadata;
import org.jclouds.rest.InvocationContext;

public class ParseNode
implements Function<HttpResponse, Node>,
InvocationContext<ParseNode> {
    private final ParseJson<Map<String, NodeWithCLBMetadata>> json;

    @Inject
    ParseNode(ParseJson<Map<String, NodeWithCLBMetadata>> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public Node apply(HttpResponse response) {
        Map map = (Map)this.json.apply(response);
        if (map == null || map.size() == 0) {
            return null;
        }
        NodeWithCLBMetadata nodeWithCLBMetadata = (NodeWithCLBMetadata)Iterables.get(map.values(), (int)0);
        Node node = Node.builder().address(nodeWithCLBMetadata.getAddress()).port(nodeWithCLBMetadata.getPort()).condition(nodeWithCLBMetadata.getCondition()).type(nodeWithCLBMetadata.getType()).weight(nodeWithCLBMetadata.getWeight()).id(nodeWithCLBMetadata.id).status(nodeWithCLBMetadata.status).metadata(ParseMetadata.transformCLBMetadataToMetadata(nodeWithCLBMetadata.metadata)).build();
        return node;
    }

    public ParseNode setContext(HttpRequest request) {
        return this;
    }

    private static class NodeWithCLBMetadata
    extends BaseNode<Node> {
        private int id;
        private Node.Status status;
        private List<ParseMetadata.CLBMetadata> metadata;

        private NodeWithCLBMetadata() {
        }
    }
}

