/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53;

import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.internal.BaseRoute53ApiExpectTest;
import org.jclouds.route53.parse.GetChangeResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="Route53ApiExpectTest")
public class Route53ApiExpectTest
extends BaseRoute53ApiExpectTest {
    HttpRequest getChange = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://route53.amazonaws.com/2012-02-29/change/C2682N5HXP0BZ4").addHeader("Host", new String[]{"route53.amazonaws.com"})).addHeader("Date", new String[]{"Mon, 21 Jan 02013 19:29:03 -0800"})).addHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=identity,Algorithm=HmacSHA256,Signature=pylxNiLcrsjNRZOsxyT161JCwytVPHyc2rFfmNCuZKI="})).build();
    HttpResponse getChangeResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/change.xml", "text/xml"))).build();

    public void testGetChangeWhenResponseIs2xx() {
        Route53Api api = (Route53Api)this.requestSendsResponse(this.getChange, this.getChangeResponse);
        Assert.assertEquals((String)api.getChange("C2682N5HXP0BZ4").toString(), (String)new GetChangeResponseTest().expected().toString());
    }

    public void testGetChangeNullWhenResponseIs404() {
        Route53Api api = (Route53Api)this.requestSendsResponse(this.getChange, this.notFound);
        Assert.assertNull((Object)api.getChange("C2682N5HXP0BZ4"));
    }
}

